/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  shell(), xshell()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <strings.h>
#include <errno.h>


extern char **environ;
extern int  os9forkc();

extern char *findmod(), *getenv(), *info_str();

static char cmd_name[600];

int _shell_secure = 0;

static int check_shell()
{
  char *shell, *cp, *cp2, *cp3, val_shell[200];
  
  errno = E_FNA;

  if ((shell = getenv("SHELL")) == NULL)
    return(0);
  
  if (info_str("valid.shells", val_shell, sizeof(val_shell)) == NULL)
    strcpy(val_shell, "shell,sh,csh");
  
  for (cp = val_shell; cp != NULL && *cp != '\0'; ) {
    cp2 = cp;
    if ((cp = index(cp, ',')) != NULL)
      *cp++ = '\0';

    while (*cp2 == ' ')
      cp2++;
    if ((cp3 = index(cp2, ' ')) != NULL)
      *cp3 = '\0';

    if (!strcmp(shell, cp2))
      return(1);
  }
  
  return(0);
}

/*
 * s h e l l 
 */
int shell(name)
  char *name;
{
  static char   *argv[] = {NULL, NULL, NULL };
  static char   cmd[300], cmd_path[100];
  register char *cp;
  int           pid, status;

  if (_shell_secure)
    if (!check_shell())
      return(-1);

  cp = name;
  while (*cp == ' ')
    cp++;

  strcpy(cmd_path, cp);

  if (cp = index(cmd_path, ' '))
    *cp++ = '\0';

  strcpy(cmd, "ex ");
  strcat(cmd, findmod(cmd_path, cmd_path));
  if (cp) {
    strcat(cmd, " ");
    strcat(cmd, name+(cp-cmd_path));
  }

  argv[1] = cmd;

  argv[0] = findmod("shell", "SYSTEM.SHELL");
  if ((pid = os9exec(os9forkc, argv[0], argv, environ, 0, 0, 3)) == -1)
    return(-1);


  while (wait(&status) != pid) ;
  
  if (status &= 0x0ffff) {
    errno = status;
    return(-1);
  }
  else
    return(0);
}

/*
 * x s h e l l
 */
int xshell(name)
  register char *name;
{
  register int pid;
  int          status;
  char         **argv;

  if (_shell_secure)
    if (!check_shell())
      return(-1);

  strcpy(cmd_name, name);
  if (getargs(cmd_name, &argv) == -1)
    return(-1);

  if ((pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 
                     0, 0, 3)) == -1) {
    free(argv);
    return(-1);
  }

  free(argv);

  while (wait(&status) != pid) ;

  if (status &= 0x0ffff) {
    errno = status;
    return(-1);
  }
  else
    return(0);
}

