/*
 *                          SETUP for SYSINFO
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/07/88   After "linting" corrected some errors ...             weo
 *
 */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>
#include <ctype.h>

#include "infomod.h"

extern int errno;

int debug;

#define DEBUG(l,s,v) if (debug>=l) (void) fprintf(stderr, s, v);

static char *Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

void usage();

/*
 * g e t _ l i n e
 *
 * "Parse" a line of the SYSINFO file
 */
static int
get_line(buf, name, type, len, data)
  register char *buf;     /* Zeile */
  char          *name;    /* Name, der gefunden wurde */
  char          *type;    /* Type (s/d/l) */
  int           *len;     /* Laenge */
  char          *data;    /* Daten */
{
  register char *cp;

  /*
   * A line of the SYSINFO file looks like
   * <name>,<type>[=[<data>|<length>]
   *
   * <data> is ignored on lock entries and should be omitted
   */
  if ((cp = index(buf, ',')) == NULL)
    return(FAILED);
  
  *cp++ = '\0';
  (void) strcpy(name, buf);  /* Name of the entry */

  /*
   * Need a '=' if not a lock entry
   */
  if (*cp != 'l' && *(cp+1) != '=')
    return(FAILED);

  *type = *cp;
  buf   = cp+2;

  switch (*type) {
    case 's':       /* String */
      (void) strcpy(data, buf);
      *len = strlen(data) + 1;
      break;

    case 'l':       /* Lock */
      *len = sizeof(LOCK);
      break;

    case 'd':       /* Data */
      *len = atoi(buf);
      break;

    case 'n':           /* Number, not supported */
      return(FAILED);

    default:
      return(FAILED);
  }

  *len = ((*len + 1) >> 1) << 1;    /* Word alignment */

  return(OK);
}

/*
 * i n f o _ s e t u p
 * 
 * Read SYSINFO file and setup SYSINFO data module
 */
int 
info_setup(info_fp)
  FILE *info_fp;
{
  char     buf[200];
  char     name[200], data[200];
  char     type;
  int      len;
  char     *data_ptr;
  char     *cp;
  mod_exec *info_module;
  int      info_event;
  int      info_size, info_num;
  INFO     *info;
  int      i, j;

  info_size = info_num  = 0;

  /*
   * 1st pass: determine required size of data module
   */
  while (fgets(buf, sizeof(buf), info_fp)) {
    /*
     * Ignore comments
     */
    if (buf[0] == '*' || buf[0] == '#')
      continue;
    if (cp = index(buf, '\n'))
      *cp = '\0';
    
    DEBUG(2, "Line = '%s'\n", buf);

    if (get_line(buf, name, &type, &len, data) == FAILED)
      continue;     /* Ignore incorrect lines */

    DEBUG(2, "name = '%s', ", name);
    DEBUG(2, "type = '%c', ", type);
    DEBUG(2, "len  = %d", len);
    if (type == 's') {
      DEBUG(2, ", data = '%s'\n", data);
    }
    else {
      DEBUG(2, "\n", 0);
    }

    info_size += (((strlen(name)+2)>>1)<<1) + len;    /* Alignment */
    info_num++;
  }

  info_size += sizeof(INFO) + (info_num-1)*sizeof(ENTRY);

  /*
   * Create the data module
   */
  if ((info_module = (mod_exec *) _mkdata_module(INFO_MODULE_NAME,
                     info_size, 0x8001, 0x0333)) == (mod_exec *) -1)
    return(FAILED);

  info = (INFO *) (((char *) info_module) + info_module->_mexec);
  info->num = info_num;
  info->rev = REVISION;   /* Revision number */

  data_ptr = ((char *) info) + (info_num-1) * sizeof(ENTRY) + sizeof(INFO);

  DEBUG(1, "info_num  = %d\n", info_num);
  DEBUG(1, "info_size = %d\n", info_size);
  DEBUG(1, "info      = %x\n", info);
  DEBUG(1, "data_ptr  = %x\n", data_ptr);

  /*
   * 2nd pass: fill the data module
   */
  (void) fseek(info_fp, 0, 0);     /* Rewind */

  i = 0;

  while (fgets(buf, sizeof(buf), info_fp)) {
    /*
     * Ignore comments
     */
    if (buf[0] == '*' || buf[0] == '#')
      continue;
    if (cp = index(buf, '\n'))
      *cp = '\0';

    DEBUG(1, "Line = '%s'\n", buf);

    if (get_line(buf, name, &type, &len, data) == FAILED)
      continue;

    DEBUG(1, "name = '%s', ", name);
    DEBUG(1, "type = '%c', ", type);
    DEBUG(1, "len  = %d", len);
    if (type == 's') {
      DEBUG(1, ", data = '%s'\n", data);
    }
    else {
      DEBUG(1, "\n", 0);
    }
  
    info->entry[i].type = type == 's' ? T_STRING : 
                          type == 'n' ? T_NUM :
                          type == 'd' ? T_DATA :
                          type == 'l' ? T_LOCK : T_UNKNOWN;

    info->entry[i].name  = data_ptr;

    /*
     * Remove leading slash of lock entry names
     */
    if (type == 'l' && name[0] == '/')
      (void) strcpy(name, name+1);

    (void) strcpy(data_ptr, name);
    data_ptr            += ((strlen(name) + 2) >> 1) << 1;
    info->entry[i].data  = data_ptr;

    switch (type) {
      case 's':
        (void) strcpy(data_ptr, data);
        break;

      case 'l':
        for (j = 0; j < sizeof(LOCK); j++)    /* Clear lock entry */
          data_ptr[j] = '\0';
        break;

      case 'd':
        for (j = 0; j < len; j++)             /* Clear data entry */
          data_ptr[j] = '\0';
        break;
    }

    data_ptr = data_ptr + len;
    i++;
  }
  
  (void) fclose(info_fp);

  /*
   * Create the event for SYSINFO
   */
  if ((info_event = _ev_creat(0, 1, -1, INFO_EVENT_NAME)) == -1) {
    (void) munload(INFO_MODULE_NAME, 0x0400);
    return(FAILED);
  }
}

/*
 * m a i n
 */
main(argc, argv)
  int  argc;
  char *argv[];
{
  int  i, j;
  FILE *info_fp;
  char *filename;
  
  filename = NULL;
  
  debug = 0;
  
  /*
   * Parse command line arguments
   */
  for (i = 1 ; i < argc; i++)
    if (argv[i][0] == '-')
      for (j = 1; j < strlen(argv[i]); j++)
        switch (tolower(argv[i][j])) {
          case '?':     /* Usage */
            usage();
            exit(1);

          case 'd':     /* Debug */
            debug = 1;
            if (argv[i][j+1] == '=')
              j += 2;
            else
              j += 1;
   
            if (isdigit(argv[i][j])) {
              debug = atoi(argv[i] + j);
              while (isdigit(argv[i][j+1]))
                j++;
            }
            break;

          default:
            usage();
            exit(_errmsg(1, "unknown option '%c'\n", argv[i][j]));
        }
    else 
      if (filename != NULL) {
        usage();
        exit(_errmsg(1, "only one path allowed\n"));
      }
      else
        filename = argv[i];

  if (filename == NULL)
    filename = INFO_FILE_NAME;

  if ((info_fp = fopen(filename, "r")) == NULL)
    exit(_errmsg(errno, "can't open sysinfo file '%s'\n", filename));
  
  if (info_setup(info_fp) == -1)
    exit(_errmsg(errno, "can't create sysinfo\n"));
}

/*
 * u s a g e
 */
void
usage()
{
  (void) fputs("Syntax: setup {<opts>} [<path>] {<opts>}\n", stderr);
  (void) fputs("Function: setup sysinfo module with data from <path>\n", stderr);
  (void) fputs("Options:\n", stderr);
  (void) fputs("     -d[=][<num>]        debug mode (<num> is debug level)\n",
               stderr);
}

