/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  scandir()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#include <stdio.h>
#include <dir.h>
#include <direct.h>

/*
 * s c a n d i r
 */
int scandir(path, entries, select, dir_sort)
  char          *path;
  struct direct ***entries;
  int           (*select)();
  int           (*dir_sort)();
{
  DIR           *dirp;
  int           size, cnt;
  struct direct *direntry;

  if ((dirp = opendir(path)) == NULL)
    return(-1);
  
  if ((size = _gs_size(dirp->dd_fd)) < 0)
    return(-1);
  
  if ((*entries = (struct direct **) malloc(size/sizeof(struct dirent) *
                                            sizeof(struct direct *))) == NULL)
    return(-1);
  
  
  for (cnt = 0; (direntry = readdir(dirp)) != NULL; ) {
    if ((*select)(direntry)) {
      if (((*entries)[cnt] =
           (struct direct *) malloc(sizeof(struct direct))) == NULL)
        return(-1);
      
      *((*entries)[cnt]) = *direntry;
      cnt++;
    }
  }
  
  qsort(*entries, cnt, sizeof(struct direct *), dir_sort);
  
  return(cnt);
}
