/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  rename(), copy()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>

extern char *malloc();
extern int xshell();


/*
 * r e n a m e
 */
int rename(old, new)
  register char *old, *new;
{
  register char *tmp;
  register char *cp;
  register int  ret;

  if ((cp = rindex(new, '/')) != NULL)
    new = cp + 1;

  if ((tmp = malloc(strlen(old)+strlen(new)+10)) == NULL)
    return(-1);
  
  sprintf(tmp, "rename %s %s", old, new);

  ret = xshell(tmp);

  free(tmp);
  return(ret);
}

/*
 * c o p y
 */
int copy(src, dest, over)
  register char *src, *dest;
  register int  over;
{
  char          tmp[300];

  sprintf(tmp, "copy %s %s%s", src, dest, over ? " -r" : "");
  return(xshell(tmp));
}

