/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  password routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 2

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <sgstat.h>

static char           EMPTY[] = "";
static FILE           *pwf = NULL;
static char           line[BUFSIZ+1];
static struct passwd  passwd;

#define TRUE  (-1)
#define FALSE (0)

extern FILE *ddfopen();

int _pw_secure = 0;

/*
 * s e t p w e n t
 */
int setpwent()
{
  char fn[100];

  if (!pwf) {
    if ((pwf = ddfopen(PASSWD, fn, "r", _pw_secure)) == NULL)
      return(-1);
  }
  else
    rewind(pwf);

  return(0);    /* OK */
}

/*
 *  e n d p w e n t
 */
void endpwent()
{
  if (pwf) {
    fclose (pwf);
    pwf = NULL;
  }
}

/*
 * p w s k i p
 */
static char *pwskip(p)
  register char *p;

{
  while (*p && *p != ',' && *p != '\n')
    ++p;

  if (*p)
    *p++ = 0;

  return(p);
}

/*
 * _ g e t p w
 */
struct passwd *_getpw(pwd, pwline)
  register struct passwd *pwd;
  char                   *pwline;
{
  register char *p;
  char          *cp;
  static char   tmp[BUFSIZ+1];
  static char   comment[81];
  static char   gecos[81];
  
  strcpy(tmp, pwline);

  p = tmp;
  pwd->pw_name = p;

  p = pwskip(p);
  pwd->pw_passwd = p;

  p = pwskip(p);
  cp = p;
  while (*cp && (*cp != '.'))
    ++cp;

  if (*cp)
    *cp++ = '\0';
 
  pwd->pw_gid = atoi(p);

  p = cp;
  p = pwskip(p);
  pwd->pw_uid = atoi(cp);

  cp = p;

  p = pwskip(p);
  pwd->pw_prio = atoi(cp);

  pwd->pw_comment = EMPTY;
  pwd->pw_gecos   = EMPTY;
  pwd->pw_age     = EMPTY;
  pwd->pw_xdir    = p;

  p = pwskip(p);
  pwd->pw_dir = p;

  p = pwskip(p);
  pwd->pw_shell = p;

  p = pwskip(p);
  pwd->pw_junk = p;

  p = pwskip(p);

  getpwopt(pwd->pw_junk, comment, PW_COMMENT, sizeof(comment));
  pwd->pw_comment = comment;
  getpwopt(pwd->pw_junk, gecos, PW_GECOS, sizeof(gecos));
  pwd->pw_gecos = gecos;
  return(pwd);
}

/*
 * g e t p w e n t
 */
struct passwd *getpwent()
{
  if (!pwf)
    if (setpwent() < 0)
      return(NULL);

  do {
    if (!fgets(line, BUFSIZ, pwf))
      return(NULL);
  } while (line[0] == '#' || line[0] == '*');

  if (!_getpw(&passwd,  line))
    return(NULL);

  return(&passwd);
}

/*
 * g e t p w u i d
 */
struct passwd *getpwuid(uid)
  int uid;

{
  int found = 0;
	
  if (setpwent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, pwf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;

    if (_getpw(&passwd, line))
      found = (passwd.pw_uid == uid);
  }

  if (found)
    return(&passwd);
  else
    return(NULL);
}

/*
 * _ s t r c c m p
 */
int _strccmp(a, b)
  register char *a,*b;
{
  register int equal = TRUE;

  while (equal && *a && *b)
    equal = (tolower(*a++) == tolower(*b++));

  if (!equal)
    --a,--b;

  return(tolower(*b) - tolower(*a));
}

/*
 * _ s t r n c c m p
 */
int _strnccmp(a, b, n)
  register char *a,*b;
  register int  n;
{
  register int equal = TRUE;

  while (equal && *a && *b && (--n > 0))
    equal = (tolower(*a++) == tolower(*b++));

  if (!equal)
    --a, --b;

  return(tolower(*b) - tolower(*a));
}


/*
 * g e t p w n a m
 */
struct passwd *getpwnam(name)
  char *name;
{
  int found = 0;
	
  if (setpwent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, pwf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getpw(&passwd, line)) 
      found = !_strccmp(passwd.pw_name, name);
  }

  if (found)
    return(&passwd);
  else
    return(NULL);
}

/*
 * f g e t p w e n t
 */
struct passwd *fgetpwent (f)
  FILE *f;

{
  struct passwd *pw = NULL;
	
  do {
    if (fgets (line, BUFSIZ, f))
      pw = _getpw(line, &passwd);
    else
      pw = NULL;
  } while (pw && (line[0] == '#' || line[0] == '*'));

  return(pw);
}

/*
 * g e t p w
 */
int getpw(uid, name)
{
  struct passwd *pw;

  if ((pw = getpwuid(uid)) == NULL)
    return(-1);

  strcpy(name, pw->pw_name);
  return(0);
}

/*
 * _ c m p u i d
 */
int _cmpuid(uidstr, uid)
  char  *uidstr;
  int   *uid;
{
  int i;

  i = 0;
  while (*uidstr && *uidstr != '.')
    if (isdigit(*uidstr))
      i = i * 10 + *uidstr++ - '0';
    else
      return(-1);
  
  if (!*uidstr++) {
    *uid = i;
    return(0);
  }

  *uid = i << 16;

    
  i = 0;
  while (*uidstr && *uidstr != '.')
    if (isdigit(*uidstr))
      i = i * 10 + *uidstr++ - '0';
    else
      return(-1);
  
  *uid |= i;
  
  if (*uidstr)
    return(0);
  return(-1);
}


/*
 * o p t s k i p
 */
static char *optskip(s)
  register char *s;
{
  while (*s && *s != '|')
    s++;
  
  if (*s)
    s++;
  return(s);
}


/*
 * g e t p w o p t
 */
int getpwopt(junk, buf, opt, max)
  register char *junk;
  char          *buf;
  register char opt;
  register int  max;
{
  register char *cp;
  int           res;

  res = -1;
  --max;
  buf[0] = '\0';
  
  while (*junk != '\0' && res)
    if (*junk != '-' || *(junk+1) != opt)
      junk = optskip(junk);
    else {
      cp   = buf;
      junk += *(junk+2) == '=' ? 3 : 2;

      while (*junk != '\0' && *junk != '|' && --max > 0)
        *cp++ = *junk++;

      *cp = '\0';
      res = 0;
      break;
    }
  
  return(res);
}

/*
 * g e c o s s k i p
 */
static char *gecosskip(s)
  register char *s;
{
  while (*s && *s != ':')
    s++;

  if (*s != '\0')
    *s++ = '\0';

  return(*s == '\0' ? NULL : s);
}

/*
 * g e t g e c o s
 */
struct gecos *getgecos(gecos_field)
  register char *gecos_field;
{
  static struct gecos gecos;
  
  if (gecos_field == NULL || gecos_field[0] == '\0')
    return(NULL);

  gecos.fullname     = gecos.organization =
  gecos.office_phone = gecos.home_phone   = NULL;

  gecos.fullname = gecos_field;

  if ((gecos.organization = gecosskip(gecos.fullname)) == NULL)
    return(&gecos);

  if ((gecos.office_phone = gecosskip(gecos.organization)) == NULL)
    return(&gecos);

  gecos.home_phone = gecosskip(gecos.office_phone);
  return(&gecos);
}
