/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  popen(), xpopen(), pclose()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <strings.h>
#include <errno.h>

extern FILE *fdopen();

extern char **environ;
extern int  os9forkc();

extern char *findmod(), *getenv(), *info_str();

static char  cmd_name[256];

struct pid_stat {
  int used;
  int pid;
  int status;
} ;

static int pids[_NFILE] = { 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0 };

int _popen_secure = 0;

/*
 * c h e c k _ s h e l l
 *
 * check for valid shells
 */
static int check_shell()
{
  char *shell, *cp, *cp2, *cp3, val_shell[200];
  
  errno = E_FNA;

  if ((shell = getenv("SHELL")) == NULL)
    return(0);
  
  if (info_str("valid.shells", val_shell, sizeof(val_shell)) == NULL)
    strcpy(val_shell, "shell,sh,csh");
  
  for (cp = val_shell; cp != NULL && *cp != '\0'; ) {
    cp2 = cp;
    if ((cp = index(cp, ',')) != NULL)
      *cp++ = '\0';

    while (*cp2 == ' ')
      cp2++;
    if ((cp3 = index(cp2, ' ')) != NULL)
      *cp3 = '\0';

    if (!strcmp(shell, cp2))
      return(1);
  }
  
  return(0);
}

/* 
 * p o p e n
 */
FILE *popen(name, mode)
  register char *name, *mode;
{
  register int  fd, fd2, fdsav, pid;
  static char   *argv[] = {NULL, NULL, NULL };
  static char   cmd[200];
  static char   cmd_path[200];
  register char *cp;

  if (_popen_secure)
    if (!check_shell())
      return(NULL);

  cp = name;
  while (*cp == ' ')
    cp++;
  strcpy(cmd_path, cp);

  if (cp = index(cmd_path, ' '))
    *cp++ = '\0';

  strcpy(cmd, "ex ");
  strcat(cmd, findmod(cmd_path, cmd_path));
  if (cp) {
    strcat(cmd, " ");
    strcat(cmd, cp);
  }

  argv[1] = cmd;

/*
 * mode kann "r" (stdout) oder "w" (stdin) sein
 */
  switch(mode[0]) {
    case 'w':
      fd = 0;
      break;

    case 'r':
      fd = 1;
      break;
  }

  if (fd == 1)
    fflush(stdout);

  fdsav = dup(fd);
  close(fd);
 
  creat("/pipe", S_IWRITE+S_IREAD);
  argv[0] = findmod("shell", "SYSTEM.SHELL");
  pid = os9exec(os9forkc, argv[0], argv, environ, 0, 0, 3);

  fd2 = dup(fd);
  close(fd);
  dup(fdsav);
  close(fdsav);

  if (pid > 0) {
    pids[fd2] = pid;
    return(fdopen(fd2, mode));
  }
  else {
    close(fd2);
    return(NULL);
  }
}


/*
 * x p o p e n
 */
FILE *xpopen(name, mode)
  register char *name, *mode;
{
  register int fd, fd2, fdsav, pid;
  char         **argv;

  if (_popen_secure)
    if (!check_shell())
      return(NULL);

  strcpy(cmd_name, name);

  if (getargs(cmd_name, &argv) == -1)
    return(NULL);

/*
 * mode kann "r" (stdout) oder "w" (stdin) sein
 */
  switch(mode[0]) {
    case 'w':
      fd = 0;
      break;

    case 'r':
      fd = 1;
      break;
  }

  if (fd == 1 && fileno(stdout) == 1)
    fflush(stdout);

  fdsav = dup(fd);
  close(fd);

  creat("/pipe", S_IWRITE+S_IREAD);
  pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 0, 0, 3);

  free(argv);

  fd2 = dup(fd);
  close(fd);
  dup(fdsav);
  close(fdsav);

  if (pid > 0) {
    pids[fd2] = pid;
    return(fdopen(fd2, mode));
  }
  else {
    close(fd2);
    return(NULL);
  }
}

/*
 * p c l o s e
 */
unsigned int pclose(fp)
  register FILE *fp;
{
  unsigned int status;
  register int pid;
  register int fd, i;

  fd = fileno(fp);

  if (pids[fd] == 0)
    return(-1);
  fflush(fp);
  fclose(fp);

  while ((pid = wait(&status)) != -1)
    if (pid == pids[fd])
      break;
    else
      for (i = 0; i < _NFILE; i++)
        if (pids[i] == pid) {
          pids[i] = 0;
          break;
        }

  if (pid == -1)
    status = -1;

  pids[fd] = 0;
  return(status);
}


