/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  pipe(), dup2()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 2

#include <stdio.h>
#include <modes.h>

/*
 * p i p e
 *
 * simulate the pipe() function of UN*X for OS9
 * very simple here ....
 */
int pipe(pv)
  register int *pv;
{
  if ((pv[0] = creat("/pipe", S_IREAD+S_IWRITE)) < 0)
    return(-1);

  if ((pv[1] = dup(pv[0])) < 0) {
    close(pv[0]);
    return(-1);
  }

  return(0);
}

/*
 * d u p 2
 *
 * simulate the dup2() function of UN*X for OS9
 * the following should do it ...
 */
int dup2(src, dest)
  register int src, dest;
{
  register int i, newfd;
  int          p[_NFILE];

  if (src == dest)
    return(dest);

  close(dest);

  for (i = 0; i < _NFILE; p[i++] = 0);

  do {
    if ((i = dup(src)) >= 0)
      p[i] = 1;
  } while(i != dest && i >= 0);

  if (i >= 0)
    p[i] = 0;

  newfd = i;

  for (i = 0; i < _NFILE; i++)
    if (p[i])
      close(i);

  return((dest == newfd) ? newfd : -1);
}

