/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  perror(), sys_errlist
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

/*
 * perror(s): print an error message
 */

#ifdef LINT
#define remote
#endif

#include <stdio.h>

extern int errno;

remote char *sys_errlist[] = {
  "",
  "000:001 aborted with an error",
  "000:002 keyboard quit",
  "000:003 keyboard interrupt",
  "000:004 ",
  "000:005 ",
  "000:006 ",
  "000:007 ",
  "000:008 ",
  "000:009 ",
  "000:010 ",
  "000:011 ",
  "000:012 ",
  "000:013 ",
  "000:014 ",
  "000:015 ",
  "000:016 ",
  "000:017 ",
  "000:018 ",
  "000:019 ",
  "000:020 ",
  "000:021 ",
  "000:022 ",
  "000:023 ",
  "000:024 ",
  "000:025 ",
  "000:026 ",
  "000:027 ",
  "000:028 ",
  "000:029 ",
  "000:030 ",
  "000:031 ",
  "000:032 ",
  "000:033 ",
  "000:034 ",
  "000:035 ",
  "000:036 ",
  "000:037 ",
  "000:038 ",
  "000:039 ",
  "000:040 ",
  "000:041 ",
  "000:042 ",
  "000:043 ",
  "000:044 ",
  "000:045 ",
  "000:046 ",
  "000:047 ",
  "000:048 ",
  "000:049 ",
  "000:050 ",
  "000:051 ",
  "000:052 ",
  "000:053 ",
  "000:054 ",
  "000:055 ",
  "000:056 ",
  "000:057 ",
  "000:058 ",
  "000:059 ",
  "000:060 ",
  "000:061 ",
  "000:062 ",
  "000:063 ",
  "000:064 illegal function code (math)",
  "000:065 ascii->numeric format conversion error (math)",
  "000:066 not a number (math)",
  "000:067 illegal argument (usually math)",
  "000:068 ",
  "000:069 ",
  "000:070 ",
  "000:071 ",
  "000:072 ",
  "000:073 ",
  "000:074 ",
  "000:075 ",
  "000:076 ",
  "000:077 ",
  "000:078 ",
  "000:079 ",
  "000:080 ",
  "000:081 ",
  "000:082 ",
  "000:083 ",
  "000:084 ",
  "000:085 ",
  "000:086 ",
  "000:087 ",
  "000:088 ",
  "000:089 ",
  "000:090 ",
  "000:091 ",
  "000:092 ",
  "000:093 ",
  "000:094 ",
  "000:095 ",
  "000:096 ",
  "000:097 ",
  "000:098 ",
  "000:099 ",
  "000:100 ",
  "000:101 ",
  "000:102 bus trap",
  "000:103 address trap",
  "000:104 illegal instruction",
  "000:105 divide by zero",
  "000:106 \"chk\" instruction trap",
  "000:107 \"trapv\" instruction trap",
  "000:108 privileged instruction",
  "000:109 trace exception",
  "000:110 illegal instruction (1010)",
  "000:111 illegal instruction (1111)",
  "000:112 exception 12",
  "000:113 coprocessor protocol violation",
  "000:114 system stack frame format error",
  "000:115 uninitialized interrupt",
  "000:116 exception 16",
  "000:117 exception 17",
  "000:118 exception 18",
  "000:119 exception 19",
  "000:120 exception 20",
  "000:121 exception 21",
  "000:122 exception 22",
  "000:123 exception 23",
  "000:124 spurious interrupt",
  "000:125 ",
  "000:126 ",
  "000:127 ",
  "000:128 ",
  "000:129 ",
  "000:130 ",
  "000:131 ",
  "000:132 ",
  "000:133 an uninitialized user TRAP (1-15) was executed",
  "000:134 ",
  "000:135 ",
  "000:136 ",
  "000:137 ",
  "000:138 ",
  "000:139 ",
  "000:140 ",
  "000:141 ",
  "000:142 ",
  "000:143 ",
  "000:144 ",
  "000:145 ",
  "000:146 ",
  "000:147 ",
  "000:148 fpcp unordered condition",
  "000:149 fpcp inexact result",
  "000:150 fpcp divide by zero",
  "000:151 fpcp underflow",
  "000:152 fpcp operand error",
  "000:153 fpcp overflow",
  "000:154 fpcp not a number",
  "000:155 exception 55",
  "000:156 pmmu configuration",
  "000:157 pmmu illegal operation",
  "000:158 pmmu access level violation",
  "000:159 exception 59",
  "000:160 exception 60",
  "000:161 exception 61",
  "000:162 exception 62",
  "000:163 exception 63",
  "000:164 no permission",
  "000:165 arguments to F$ChkNam didn't match",
  "000:166 system stack overflow",
  "000:167 invalid event ID number",
  "000:168 event not found",
  "000:169 the event is busy",
  "000:170 impossible event parameters",
  "000:171 system data structures have been damaged",
  "000:172 module revision is incompatable with operating system",
  "000:173 path became lost because network node was down",
  "000:174 bad disk partition, or no active partition",
  "000:175 ",
  "000:176 ",
  "000:177 ",
  "000:178 ",
  "000:179 ",
  "000:180 ",
  "000:181 ",
  "000:182 ",
  "000:183 ",
  "000:184 ",
  "000:185 ",
  "000:186 ",
  "000:187 ",
  "000:188 ",
  "000:189 ",
  "000:190 ",
  "000:191 ",
  "000:192 ",
  "000:193 ",
  "000:194 ",
  "000:195 ",
  "000:196 ",
  "000:197 ",
  "000:198 ",
  "000:189 ",
  "000:200 the path table is full",
  "000:201 bad path number",
  "000:202 system IRQ table is full",
  "000:203 bad I/O mode",
  "000:204 system device table is full",
  "000:205 bad module header",
  "000:206 system module directory is full",
  "000:207 memory full",
  "000:208 unknown service code ",
  "000:209 non-sharable module is busy",
  "000:210 bad page address",
  "000:211 end of file",
  "000:212 IRQ vector is busy",
  "000:213 non-existing segment",
  "000:214 file not accessible",
  "000:215 bad pathlist",
  "000:216 file not found",
  "000:217 file segment list is full",
  "000:218 creating an existing file",
  "000:219 illegal memory block address",
  "000:220 modem data carrier lost",
  "000:221 module not found",
  "000:222 system clock not running",
  "000:223 deleting stack memory",
  "000:224 illegal process ID",
  "000:225 bad IRQ parameter",
  "000:226 no children",
  "000:227 invalid trap number",
  "000:228 process has aborted",
  "000:229 system process table is full",
  "000:230 illegal fork parameter",
  "000:231 known module",
  "000:232 bad module CRC",
  "000:233 unprocessed signal pending",
  "000:234 non executable module",
  "000:235 bad name",
  "000:236 bad module header parity",
  "000:237 no RAM available",
  "000:238 directory is not empty",
  "000:239 no available task number",
  "000:240 illegal unit (drive) number",
  "000:241 bad sector number",
  "000:242 media is write protected",
  "000:243 I/O error - bad check sum",
  "000:244 read error",
  "000:245 write error",
  "000:246 device not ready",
  "000:247 seek error",
  "000:248 media full",
  "000:249 incompatable media",
  "000:250 device busy",
  "000:251 disk media has changed",
  "000:252 record is busy",
  "000:253 non-sharable file/device is busy",
  "000:254 I/O deadlock error",
  "000:255 device is format protected" };

int sys_nerr = 256;

int perror(s)
  char *s;
{
  fprintf(stderr, "%s: %s\n", _prgname(), s);
  if (errno > sys_nerr)   /* zu grosse Fehlernummer? */
    fprintf(stderr, "%03d.%03d \n", errno >> 8, errno & 0xFF);
  else {
    fputs(sys_errlist[errno], stderr);
    fputs("\n", stderr);
  }
  
  return(errno);
}

/*
 * s t r e r r o r
 */
char *strerror(err)
  int err;
{
  static char errbuf[40];

  if (err > sys_nerr) {   /* zu grosse Fehlernummer? */
    sprintf(errbuf, "%03d.%03d \n", err >> 8, err & 0xFF);
    return(errbuf);
  }
  else
    return(sys_errlist[errno]);
}  
  
