/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  module directory routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1


#include <stdio.h>
#include <mdir.h>

/* Module-Directory entry */
typedef struct {
  struct modhcom *md_mptr;
  long           md_group;
  long           md_static;
  short          md_link;
  short          md_mchk;
} ModDir;

#define TRUE  1
#define FALSE 0

static mentry  ret;
static ModDir  *head = NULL;
static int     pos;
static int     count, max;
static int     size;

/*
 * _ m o p e n
 */
int _mopen()
{
  register int maxcount;

  size     = sizeof(ModDir);
  maxcount = 0;
  if (head)
    _mclose();

  head = NULL;

  do {
    maxcount += 80;
    if (!(head = (ModDir *) realloc(head, maxcount * size + 2)))
      return(-1);
  } while ((count = _get_module_dir(head, maxcount * size + 2)) >
           maxcount * size);
           
  max = count / size;
  pos = 0;
  return(0);
}

/*
 * _ m c l o s e
 */
int _mclose()
{
  if (head) {
    free(head);
    head = NULL;
    return(0);
  }
  else
    return(-1);
}

/*
 * _ m r e a d
 */
mentry *_mread()
{
  register struct modhcom *md;

  if ((!head) || (pos >= max))
    return(NULL);

  while ((pos < max) && (head[pos].md_mptr == NULL))
    ++pos;

  if (pos >= max)
    return(NULL);

  md         = head[pos].md_mptr;
  ret.m_ptr  = md;
  _cpymem(0, sizeof(struct modhcom), md, &ret.m_head);
  _cpymem(0, sizeof(ret.m_name), (char *) md + ret.m_head._mname, ret.m_name);

  ret.m_link = head[pos].md_link;
  ++pos;
  return(&ret);
}

/*
 * _ m s e e k
 */
int _mseek(position, place)
  int position, place;
{
  int t;

  if ((place < 0) || (place > 2) || (!head))
    return(-1);

  switch (place) {
    case 0:
      if ((position >= 0) && (position < max))
        pos = position;
      else
        return(-1);
      break;

    case 1:
      t = pos + position;
      if ((t >= 0) && (t < max))
        pos = t;
      else
        return(-1);
      break;

    case 2:
      t = max -1 + position;
      if ((t >= 0) && (t < max))
        pos = t;
      else
        return(-1);
      break;

    default:
      return(-1);
  }
  return(pos);
}

/*
 * _ m t e l l
 */
int _mtell()
{
  if (!head)
    return(-1);
  else
    return(pos);
}

/*
 * _ m r e w i n d
 */
int _mrewind()
{
  if (!head)
    return(-1);

  pos = 0;
  return(0);
}

/*
 * _ m e x i s t
 */
mentry *_mexist(name)
  register char *name;
{
  register mentry *scan;
  register int    siz;
  int             found;

  found = FALSE;
  if (_mopen() < 0)
    return(NULL);

  siz = strlen(name);
  while (scan = _mread())
    if (!_cmpnam(scan->m_name, name, siz)) {
      found = TRUE;
      break;
    }

  _mclose();
  return(found ? scan : NULL);
}

/*
 * g e t m o d n a m e
 */
char *getmodname(mod_addr)
  register struct modhcom *mod_addr;
{
  register mentry *mentry;

  if (_mopen() == -1)
    return(NULL);

  while ((mentry = _mread()) != NULL)
    if (mod_addr == mentry->m_ptr)
      return(mentry->m_name);
  
  return(NULL);
}
