/************************************************************************
 *                                                                      *
 *   Copyrighted (C) 1987, 1988 by Ulrich Dessauer, Germering           *
 *                                                  (W-Germany)         *
 *                                                                      *
 *   This program can be copied and distributed freely for any          *
 *   non-commercial purposes. This program can only be incorporated     *
 *   into commercial software with the permission of the author.        *
 *                                                                      *
 *   If you should modify this program, the author would appreciate     *
 *   informations about the changes. Please send a (context) diff or    *
 *   the complete source to:                                            *
 *   address:     Ulrich Dessauer                                       *
 *                Kerschensteinerstr. 45                                *
 *                D-8034 Germering                                      *
 *                West Germany                                          *
 *                                                                      *
 *   e-mail:      ud@mutec.UUCP, ud@altger.UUCP                         *
 *                                                                      *
 *   Program:     man                                                   *
 *   Version:     0.98                                                  *
 *   Module:      man.c                                                 *
 *   Description: Prints an manual entry using the favorite pager       *
 *   Functions:   usage ()                                              *
 *                main (int, **char)                                    *
 *                manual (*char, **char)                                *
 *                                                                      *
 *   Auther(s):                                                         *
 *         Ulrich Dessauer    (ud)                                      *
 *                                                                      *
 *   Edition History                                                    *
 *    # | Date   | By  | Changes                                        *
 *   ===+========+=====+==============================================  *
 *    1 |03.10.88| ud  | Seperated includefiles for man and mwb         *
 *                                                                      *
 ************************************************************************/
# ifndef LINT
static char *copyright = "Copyrighted (C) 1987, 1988 by Ulrich Dessauer, Germering, W-Germany";
# endif LINT

# include "man.h"
# include <modes.h>
# include <ctype.h>

extern void	exit ();
extern void	free ();
extern char	*fgets ();
extern char	*getenv ();
extern char	*info_str ();
extern char	*malloc ();
extern char	*strcat ();
extern char	*strcpy ();
extern FILE	*fopen ();

extern int	errno;

# define 	MANEXT		".man"

char		*mandir,*proff,*mindex,*pager;

char		*help[] = {
	"Syntax: man [<opts>]\n",
	"Function: Prints a manual entry\n",
	"Options:\n",
	"     none.\n",
	NULL
};

/*
 *	u s a g e
 */
usage ()
{
	int t;

	for (t=0;help[t];++t)
		(void) fputs(help[t],stderr);
}

/*
 *	m a i n
 */
main (argc,argv,envp)
int argc;
char *argv[];
char *envp[];
{
	int		t;
	int		noargs;
	char		*x;
	char 		s[256];
	register char	*entry,*file;
	char		lastfile[40];
	FILE		*fp;
	char		*mn;
	
	noargs = 1;
	
	/* Parse arguments */
	for (t=1;t<argc;++t)
		if (*argv[t] == '-') {
			x = argv[t] + 1;
			while (*x) {
				switch (*x) {
					case '?':
					default:
						usage ();
						if (*x != '?')
							(void) fprintf (stderr, "Unknown flag '%c'\n",*x);
						exit (1);
				}
				if (*x) ++x;
			}
		} else
			noargs = 0;
	if (noargs) {
		usage ();
		exit(_errmsg(1, "No manual entry\n"));
	}
	
	/* Get some sysinfo entries */
	if (!(mn = malloc (80)))
		exit (_errmsg (errno,"Out of memory\n"));
	if (!(mandir = getenv ("MANDIR"))) {
		if (!info_str ("mwb.mandir",mn,80))
			mandir = MANDIR;
		else {
			mandir = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory\n"));
		}
	}
	if (!(proff = getenv ("PROFF"))) {
		if (!info_str ("mwb.proff",mn,80))
			proff = PROFF;
		else {
			proff = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory!\n"));
		}
	}
	if (!(mindex = getenv ("INDEX"))) {
		if (!info_str ("mwb.index",mn,80))
			mindex = INDEX;
		else {
			mindex = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory\n"));
		}
	}
	if (!(pager = getenv ("PAGER"))) {
		if (!info_str ("mwb.pager",mn,80))
			pager = PAGER;
		else {
			pager = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory!\n"));
		}
	}
	free (mn);
	if (chdir (mandir) < 0)
		exit (_errmsg (errno,"Can't change to '%s'!\n",mandir));
	*lastfile = '\0';
	fp = NULL;
	for (t=1;t<argc;++t)
		if (*argv[t] != '-') {
			x = argv[t];
			if (fp)
				(void) fseek (fp, 0, 0);
			else
				if (!(fp = fopen (mindex,"r")))
					exit (_errmsg (errno,"Can't open index file!\n"));
			while (fgets (s,80,fp)) {
				s[strlen (s) - 1] = '\0';
				entry = s;
				file = s;
				while (*file && (!isspace (*file)))
					++file;
				if (*file) {
					*file++ = '\0';
					while (isspace (*file))
						++file;
				}
				if (!*file) continue;
				if ((!_cmpnam (entry,x,strlen (x))) && (strcmp (lastfile,file))) {
					if (manual (file,envp))
						break;
					(void) strcpy (lastfile,file);
				}
			}
		}
	if (fp)
		(void) fclose (fp);
}

/*
 *	m a n u a l
 */
manual (x,en)
char *x;
char *en[];
{
	char	*args[6];
	char	format[256];
	int	pid, t, status;

	(void) strcpy (format,x);
	(void) strcat (format,MANEXT);
	if (access (format,S_IREAD)) {
		if (access (x,S_IREAD)) {
			printf ("Entry %s not found\n",x);
			return (0);
		}
		args[0] = "shell";
		args[1] = proff;
		args[2] = x;
		args[3] = "!";
		args[4] = pager;
		args[5] = NULL;
	} else {
		args[0] = pager;
		args[1] = format;
		args[2] = NULL;
	}
	if ((pid = os9exec (os9forkc,args[0],args,en,0,0,3)) < 0)
		exit (_errmsg (errno,"Can't fork '%s'\n", args[1]));
	status = 0;
	while (((t = wait (&status)) != pid) && (t != -1))
		;
	if ((t == pid) && status)
		return (1);
	else
		return (0);
}
