/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  isatty(), isapipe()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <sgstat.h>

/*
 * i s w h a t
 */
static int iswhat(p)
  int p;
{
  struct  _sgs  opt;

  if (_gs_opt(p, &opt) < 0)
    return(-1);
  return(opt._sgs_class);
}

/*
 * i s a t t y
 */
int isatty(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 0);
}


/*
 * i s a p i p e
 */
int isapipe(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 1);
}

