typedef struct {
  int status;     /* Status (locked/unlocked) */
  int flags;      /* Flags */
  int timestamp;  /* Wann wurde gelocked */
  int pid;        /* Prozessid */
  int signal;     /* Signal zu killen */
  int datbeg;     /* Startzeit des Prozesses */
  int timbeg;
  int future[4];
} LOCK;

typedef struct {
  char *name;     /* Name des Eintrags */
  char *data;     /* Zeiger auf Daten */
  int  type;      /* Typ, noch nicht benutzt */
  int  datasize;  /* Groesse des Datenbereichs */
  int  future[4];
} ENTRY;

typedef struct {
  int   num;      /* Anzahl Eintraege */
  int   size;     /* Gesamtgroesse, unbenutzt */
  int   rev;      /* Revision */
  int   future[8];
  LOCK  ev_lock;  /* Lock-Info fuer das Event, unbenutzt */
  ENTRY entry[1]; /* Eintraege */
} INFO;

#define INFO_MODULE_NAME "SysInfo"        /* Name des Daten-Moduls */
#define INFO_EVENT_NAME "SysInfo"         /* Name des Events */
#define INFO_FILE_NAME "/dd/SYS/sysinfo"  /* Default-Path der sysinfo-Datei */

#define TRUE  1
#define FALSE 0

#define OK      0
#define FAILED -1

#define T_UNKNOWN 0   /* ??? */
#define T_STRING 1    /* String (s) */
#define T_NUM 2       /* Zahl (n), unbenutzt */
#define T_DATA 3      /* Daten (allgemein) */
#define T_LOCK 4      /* Lock-Info */

#define ST_LOCKED 1   /* Device ist gelocked */
#define ST_FREE 0     /* Device ist frei */

#define REVISION 1    /* Revision */
