/*
 *                            SYSINFO Library
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/06/88   Corrected modlink parameters                          weo
 * 02  11/21/88   Added info_kill(), changed info_signal() to
 *                info_do_signal() (as proposed by Ulli)                weo
 */

#define PATCHLEVEL 2

#include <stdio.h>
#include <module.h>
#include <strings.h>
#include <procid.h>
#include <errno.h>
#include "infomod.h"

extern int errno;
static char *Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

/*
 * l i n k _ i n f o _ m o d
 *
 * Link to SYSINFO data module
 */
static INFO *
link_info_mod()
{
  register mod_exec *info_module;

  if ((info_module = (mod_exec *) modlink(INFO_MODULE_NAME, 
                                          mktypelang(MT_DATA, ML_ANY))) ==
      (mod_exec *) -1)
    return(NULL);   /* can't link */

  return((INFO *) (((char *) info_module) + info_module->_mexec));
}

/*
 * u n l i n k _ i n f o _ m o d
 *
 * unlink from SYSINFO data module
 */
static void 
unlink_info_mod()
{
  (void) munload(INFO_MODULE_NAME, 0x0400);
}

/*
 * i n f o _ e n t r y
 *
 * Get pointer to an entry within the SYSINFO data module. Needs
 * name of the entry (case sensitiv) and its type.
 */
static ENTRY *
info_entry(name, type)
  register char *name;
  register int  type;
{
  register INFO *info;
  register int  i;

  if ((info = link_info_mod()) == NULL) /* Link to data module */
    return(NULL);

  /*
   * Check revision (for compatiblity reasons)
   */
  if (info->rev != REVISION) {
    unlink_info_mod();
    return(NULL);
  }

  for (i = 0; i < info->num; i++)         /* search entry by name */
    if (!strcmp(info->entry[i].name, name) &&
        (info->entry[i].type == type))    /* desired type? */
      return(&(info->entry[i]));          /* all ok, return pointer */
  
  unlink_info_mod();
  errno = E_PNNF;
  return(NULL);
}

/*
 * i n f o _ t y p e
 *
 * Determine type of SYSINFO entry. Needs only the name of the entry.
 */
int 
info_type(name)
  char *name;
{
  register INFO *info;
  register int  i;
  register int  type;

  if ((info = link_info_mod()) == NULL)     /* Link to data module */
    return(NULL);

  for (i = 0; i < info->num; i++)           /* Search entry */
    if (!strcmp(info->entry[i].name, name)) {
      type = info->entry[i].type;
      unlink_info_mod();
      return(type);                         /* found, return type */
    }
  
  unlink_info_mod();
  errno = E_PNNF;
  return(FAILED);
}  

/*
 * i n f o _ s t r
 *
 * Get a string from SYSINFO. Needs name, buffer, and max. length.
 */
char *
info_str(name, str, len)
  register char *name;
  register char *str;
  register int  len;
{
  register ENTRY *entry;

  /*
   * Get a pointer to the desired entry
   */
  if ((entry = info_entry(name, T_STRING)) == NULL)
    return(NULL);       /* Not found */ 

  (void) strncpy(str, entry->data, len-1);   /* Copy */
  str[len-1] = '\0';
  unlink_info_mod();
  return(str);
}

/*
 * i n f o _ n u m
 *
 * Get number from SYSINFO
 */
int 
info_num(name)
  register char *name;
{
  register ENTRY *entry;

  /*
   * Get a pointer to the entry
   */
  if ((entry = info_entry(name, T_NUM)) == NULL)
    return(FAILED);

  unlink_info_mod();
  return(*((int *) entry->data));
}

/*
 * i n f o _ i s _ l o c k e d
 *
 * Check, if a lock entry is locked. Needs name.
 */
int 
info_is_locked(name)
  register char *name;
{
  int            EvID;
  int            status;
  procid         procdesc;
  register LOCK  *lock;
  register ENTRY *entry;

  /*
   * Remove a leading slash ("/t7" is equal to "t7")
   */
  if (name[0] == '/')
    name++;

  /*
   * Get pointer to entry
   */
  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  /*
   * Link to the SYSINFO event
   */
  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  /*
   * Wait, until we can access the entry.
   * We should check for a timeout here ... (perhaps alarms?)
   */
  while (_ev_wait(EvID, 0, 0) != 0) ;

  /*
   * Now we can access the entry
   */
  lock   = (LOCK *) entry->data;
  status = lock->status;            /* Get status */

  if (status == ST_LOCKED)          /* Locked? */
    if (lock->pid == 0)             /* Process ID? */
      status = ST_FREE;             /* NOT LOCKED! */
    else
      /* 
       * Now we have to check, whether the existing process
       * still exists. We do this by checking the PID and the
       * start time of the locking process
       */
      if (_get_process_desc(lock->pid, sizeof(procdesc), 
                            &procdesc) == -1 ||
          lock->timbeg != procdesc._timbeg ||
          lock->datbeg != procdesc._datbeg)
        status = ST_FREE;     /* Meanwhile, the process has died! */

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();

  return(status == ST_FREE ? OK : FAILED);
}

/*
 * i n f o _ l o c k
 *
 * Lock a SYSINFO entry
 */
int 
info_lock(name, signal)
  register char *name;
  int           signal;
{
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register int   timeout;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  /*
   * Now we can access the entry
   */
  lock = (LOCK *) entry->data;
  
  if (lock->status == ST_LOCKED) {    /* locked? */
    if (lock->pid != 0) {             /* Process ID given? */
        timeout = 0;
        while (lock->status == ST_LOCKED &&
               _get_process_desc(lock->pid, sizeof(procdesc), 
                                 &procdesc) != -1 &&
            lock->timbeg == procdesc._timbeg &&
            lock->datbeg == procdesc._datbeg) {
  
          if (timeout++ > 20) {   /* Timeout? */
            (void) _ev_signal(EvID, 0);
            _ev_unlink(EvID);
            unlink_info_mod();
            return(FAILED);
          }

          if (lock->signal != -1)           /* May we send a signal to the */
                                            /* locking process? */
            (void) kill(lock->pid, lock->signal);

          (void) _ev_signal(EvID, 0);    /* Now others may access */
          (void) sleep(5);               /* Wait a bit ... */
          while (_ev_wait(EvID, 0, 0) != 0) ;
        }
    }
  }

  lock->status    = ST_LOCKED;
  lock->timestamp = time(NULL);
  lock->pid       = getpid();
  lock->signal    = signal;     /* A process which want lock may send us */
                                /* this signal */

  if (_get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1) {
    lock->timbeg = procdesc._timbeg;    /* Our start time */
    lock->datbeg = procdesc._datbeg;
  }
  else {
    lock->timbeg = 0;
    lock->datbeg = 0;
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(OK);
}

/*
 * i n f o _ u n l o c k
 *
 * Unlock
 */
int 
info_unlock(name)
  register char *name;
{
  int            EvID;
  procid         procdesc;
  register LOCK  *lock;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0);

  lock = (LOCK *) entry->data;

  if (lock->status == ST_LOCKED && lock->pid == getpid() &&
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg)     /* IS it "our" lock? */
    lock->status = ST_FREE;     /* Unlock */
  
  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(OK);
}

/*
 * i n f o _ c h a n g e
 *
 * Change signal number of a lock
 */
int 
info_change(name, signal)
  register char *name;
  int           signal;
{
  int            err;
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  lock = (LOCK *) entry->data;

  err = FAILED;

  if (lock->status == ST_LOCKED && lock->pid == getpid() && 
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg) {   /* Locking proc. still existing? */
    err = OK;
    lock->signal = signal;    /* new signal code */
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(err);
}


/*
 * i n f o _ d o _ s i g n a l
 *
 * Send a signal to a locking process
 */
static int
info_do_signal(name, offset)
  register char *name;
  register int  offset;
{
  int            err;
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  lock = (LOCK *) entry->data;

  err = FAILED;

  if (lock->status == ST_LOCKED &&
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg) {   /* Locking proc. still existing? */

    if (lock->signal != -1) {           /* May we send a signal? */
      err = OK;
      (void) kill(lock->pid, lock->signal + offset);    /* Yes, "kill" him! */
    }
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(err);
}

/*
 * i n f o _ s i g n a l
 *
 * Send a signal to a locking process
 */
int
info_signal(name)
  register char *name;
{
  return info_do_signal(name, 0);
}

/*
 * i n f o _ k i l l
 *
 * Send a signal+1 to locking process
 */
int
info_kill(name)
  register char *name;
{
  return info_do_signal(name, 1);
}

