/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  group routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <ctype.h>
#include <grp.h>

static FILE         *grpf = NULL;
static char         line[BUFSIZ+1];
static char         *member[MAX_MEM+1];
static struct group group;

#define TRUE  (-1)
#define FALSE (0)

int _grp_secure = 0;

extern FILE *ddfopen();

/*
 * s e t g r e n t
 */
int setgrent()
{
  char fn[100];

  if (!grpf) {
    if (!(grpf = ddfopen(GROUP, fn, "r", _grp_secure)))
      return(-1);
  }
  else
    rewind(grpf);
  
  return(0);
}

/*
 * e n d g r e n t
 */
void endgrent()
{
  if (grpf) {
    fclose (grpf);
    grpf = NULL;
  }
}

/*
 * g r s k i p
 */
static char *grskip(p)
  register char *p;

{
  while (*p && *p != ':')
    ++p;
  if (*p)
    *p++ = '\0';
  return(p);
}

/*
 * g r s k i p 2
 */
static char *grskip2 (p)
  register char *p;

{
  while (*p && (*p != ',') && (*p != '\n'))
    ++p;

  if (*p) 
    if (*p != '\n')
      *p++ = '\0';
    else
      *p = '\0';

  return(p);
}

/*
 * _ g e t g r
 */
struct group *_getgr(gr, grline)
  register struct group *gr;
  char                  *grline;

{
  register char *p;
  char          *cp;
  int           t;
  static char   tmp[BUFSIZ+1];

  strcpy(tmp, grline);
  
  p = tmp;
  gr->gr_name = p;

  p = grskip(p);
  gr->gr_passwd = p;

  p = grskip(p);
  cp = p;

  p = grskip(p);
  gr->gr_gid = atoi(cp);
  t = 0;
  while ((t < MAX_MEM) && *p) {
    member[t++] = p;
    p = grskip2(p);
  }

  member[t] = NULL;
  gr->gr_mem = member;
  while(*p && *p != '\n')
    p++;
  *p = '\0';
  return(gr);
}

/*
 * g e t g r e n t
 */
struct group *getgrent()
{
  if (!grpf)
    if (setgrent() < 0)
      return(NULL);
    
  do {
    if (!fgets(line, BUFSIZ,grpf))
      return(NULL);
  } while (line[0] == '#' || line[0] == '*');

  if (!_getgr(&group, line))
    return(NULL);

  return(&group);
}

/*
 * g e t g r g i d
 */
struct group *getgrgid (gid)
  int gid;

{
  int found = 0;
	
  if (setgrent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, grpf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getgr(&group, line))
      found = (group.gr_gid == gid);
  }

  if (found)
    return(&group);
  else
    return(NULL);
}

/*
 * g e t g r n a m
 */
struct group *getgrnam(name)
  char *name;

{
  int found = 0;
	
  if (setgrent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, grpf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getgr(&group, line)) 
      found = (!_strccmp(group.gr_name, name));
  }

  if (found)
    return(&group);
  else
    return(NULL);
}

/*
 * f g e t g r e n t
 */
struct group *fgetgrent(f)
  FILE *f;

{
  struct group *gr = NULL;
	
  do {
    if (fgets(line, BUFSIZ, f))
      gr = _getgr(line, &group);
    else
      gr = NULL;
  } while (gr && (line[0] == '#' || line[0] == '*'));

  return(gr);
}

/*
 * g e t g r o u p s
 */
int getgroups(num, gids)
  int num;
  int *gids;
{
  struct group *gr;
  int          i;

  if (setgrent() < 0)
    return(-1);
  
  for (i = 0; i < num; i++)
    if (!(gr = getgrent())) {
      endgrent();
      return(i);
    }
    else
      gids[i] = gr->gr_gid;

  endgrent();
  return(num);
}
