/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getwd(), getx()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>

FILE *xpopen();

/*
 * g e t w x d
 */
static char *getwxd(wd, opt)
  register char *wd;
  register char *opt;
{
  register FILE *fp;
  char          tmp[40];
  register char *cp;
  
  wd[0] = '\0';

  (void) strcpy(tmp, "/h0/CMDS/pd");
  if (opt != NULL)
    (void) strcat(tmp, opt);

  if ((fp = xpopen(tmp, "r")) == NULL)
    return(NULL);

  if (fgets(wd, 200, fp) == NULL)
    return(NULL);

  if ((cp = index(wd, '\n')) != NULL)
    *cp = '\0';

  while (fgets(tmp, sizeof(tmp)-1, fp) != NULL) ;
  
  pclose(fp);
  return(wd);
}

/*
 * g e t w d
 */
char *getwd(wd)
  char *wd;
{
  return(getwxd(wd, NULL));
}

/*
 * g e t x d
 */
char *getxd(wd)
  char *wd;
{
  return(getwxd(wd, " -x"));
}
