/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getlogin()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <strings.h>
#include <utmp.h>
#include <pwd.h>

static char *chkpw();

/*
 * g e t l o g i n
 */
char *getlogin()
{
  register char        *cp;
  static char          user[33];
  char                 line[33];
  register int         res;
  register struct utmp *utmp;
	
  if (_gs_devn(0, line+1) < 0)
    return (NULL);

  line[0] = '/';
  setwhoent();
  res = 0;

  while ((!res) && (utmp = getwhoent()) != NULL)
    res = !strcmp(line, utmp->ut_line);

  if (res) {
    strcpy(user, utmp->ut_user);
    cp = user;
  }
  else
    cp = NULL;
  endwhoent ();

  if (cp == NULL && (cp = chkpw()) != NULL) {
    strcpy(user, cp);
    cp = user;
  }

  return(cp);
}

/*
 * c h k p w
 */
static char *chkpw()
{
  register struct passwd *pw;
	
  if (pw = getpwuid(getuid() & 0x0ffff)) {
    endpwent();
    return(pw->pw_name);
  }
  else {
    endpwent();
    return(NULL);
  }
}
