/*
 *                          GETINFO for SYSINFO
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/06/88   Corrected modlink parameters                          weo
 *
 */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>
#include <procid.h>
#include <errno.h>
#include "infomod.h"

extern int errno;

extern char *getmodname();

static void display_info();
static void usage();

int disp_all, disp_locks;

static char Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

/*
 * l i n k _ i n f o _ m o d
 */
static INFO *
link_info_mod()
{
  register mod_exec *info_module;

  if ((info_module = (mod_exec *) modlink(INFO_MODULE_NAME,
                                          mktypelang(MT_DATA, ML_ANY))) ==
      (mod_exec *) -1)
    return(NULL);

  return((INFO *) (((char *) info_module) + info_module->_mexec));
}

/*
 * u n l i n k _ i n f o _ m o d
 */
static void 
unlink_info_mod()
{
  munload(INFO_MODULE_NAME, 0x0400);
}

/*
 * m a i n
 */
main(argc, argv)
  int  argc;
  char *argv[];
{
  register INFO *info;
  register int  i, j;
  int           clear_event, unlock;
  int           arg_count;
  int           EvID;

  clear_event = unlock = disp_all = disp_locks = FALSE;
  arg_count = 0;

  /*
   * Parse command line arguments
   */  
  for (i = 1; i< argc; i++)
    if (argv[i][0] == '-')
      for (j = 1; j < strlen(argv[i]); j++)
        switch(tolower(argv[i][j])) {
          case '?':
            usage();
            exit(1);
          case 'c':       /* clear event */
            clear_event = TRUE;
            break;
          case 'a':
            disp_all = TRUE;
            break;
          case 'l':
            disp_locks = TRUE;
            break;
          case 'u':       /* unlock device */
            unlock = TRUE;
            break;
          default:
            usage();
            exit(_errmsg(1, "unknown option '%c'\n", argv[i][j]));
        }
    else
      arg_count++;

  if ((info = link_info_mod()) == NULL)
    exit(_errmsg(errno, "can't link to sysinfo data module\n"));

  if (info->rev != REVISION) {
    unlink_info_mod();
    exit(_errmsg(1, "Revision mismatch, (mod = %d, getinfo = %d)\n",
                 info->rev, REVISION));
  }

  if (clear_event) {    /* Reset the SYSINFO event */
    if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
      unlink_info_mod();
      exit(_errmsg(errno, "can't link to event\n"));
    }

    if (_ev_set(EvID, 0, 0) == -1) {
      unlink_info_mod();
      exit(_errmsg(errno, "can't set event\n"));
    }
    _ev_unlink(EvID);
  }
  
  if (unlock)     /* Unlock an entry */
    for (i = 1; i < argc; i++)
      if (argv[i][0] != '-')
        if (info_lock(argv[i], 0) != -1)
          info_unlock(argv[i], 0);
        else
          fprintf(stderr, "can't unlock %s\n", argv[i]);

  if ((!clear_event && !unlock) || disp_locks || disp_all) {
    printf("SYSINFO Rev. %d\n\n", info->rev);
    printf("%-20.20s  %-10.10s  %-40.40s\n\n", "Name", "Type", "Parameter");
    for (i = 0; i < info->num; i++)
      display_info(&(info->entry[i]));      /* Display entries */
  }

  unlink_info_mod();
}

/*
 * d i s p l a y _ i n f o
 */
static void 
display_info(entry)
  register ENTRY *entry;
{
  register LOCK     *lock;
  register procid   procdesc;
  register mod_exec *modhdr;
  register char     *mod_name;

  if (disp_all || entry->type == T_LOCK) {  
    printf("%-20.20s  %-10.10s  ", entry->name,
           entry->type == T_UNKNOWN ? "*unknown*" :
           entry->type == T_STRING ? "String" :
           entry->type == T_NUM ? "Num" :
           entry->type == T_LOCK ? "Lock" : "* ??? *");
  }

  switch (entry->type) {
    case T_UNKNOWN:
      break;

    case T_STRING:
      if (!disp_all)
        break;
      printf("%-40.40s", entry->data);
      break;

    case T_NUM:
      if (!disp_all)
        break;
      printf("not supported yet");
      break;

    case T_LOCK:
      lock = (LOCK *) entry->data;
      if (lock->status == ST_FREE)
        printf("not locked");
      else {
        if ((_get_process_desc(lock->pid, sizeof(procdesc),
                                           &procdesc)) == -1 ||
            lock->timbeg != procdesc._timbeg ||
            lock->datbeg != procdesc._datbeg) 
                                            /* Locking proc. still existing? */
          printf("not locked, orphaned lock (process id %d)", lock->pid);
        else {
          mod_name = getmodname(procdesc._pmodul);
          printf("locked by process %d (%s)", lock->pid, mod_name);
        }
      }
      break;

    default:
      printf("possible damage of sysinfo data (invalid type)");
  }

  if (disp_all || entry->type == T_LOCK)  
    printf("\n");
}

/*
 * u s a g e
 */
static void 
usage()
{
  fputs("Syntax: getinfo [<opts>] {<parm> [<opts>]}\n", stderr);
  fputs("Function: display or modify sysinfo data\n", stderr);
  fputs("Options:\n", stderr);
  fputs("     -l   display locks (default)\n", stderr);
  fputs("     -a   display not only locks\n", stderr);
  fputs("     -c   clear sysinfo event\n", stderr);
  fputs("     -u   unlock devices (given as parm)\n", stderr);
}
