/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getargs()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>

#define sp _sp

#define TRUE  1
#define FALSE 0

/*
 * g e t a r g s
 */
getargs(s, args)
  register char *s;
  char     ***args;
{
  register int  i;
  register char *sp;
  register char qchar;
  int           argsnum;
  
  i = 0;
  argsnum = 40;

  if ((*args = (char **) malloc(argsnum * sizeof(char *))) == NULL)
    return(-1);

  while (TRUE) {
    if (i >= argsnum-1) {
      argsnum += 40;
      if ((*args = (char **) realloc(*args, argsnum * sizeof(char *))) == NULL)
        return(-1);
    }

    while (*s == ' ' || *s == '\t')
      ++s;
    if (*s == '\n' || *s == '\0')
      break;

    (*args)[i++] = sp = s;

    qchar = 0;
    while (*s != '\0' && *s != '\n') {
      if (qchar == 0 && (*s == ' ' || *s == '\t')) {
        ++s;
        break;
      }

      switch (*s) {
        case '"':
        case '\'':
          if (qchar == *s) {
            qchar = 0;
            ++s;
            break;
          }

          if (qchar)
            *sp++ = *s++;
          else
            qchar = *s++;
          break;

        default:
          *sp++ = *s++;
          break;
      }
    }
    *sp++ = 0;
  }

  (*args)[i] = NULL;
  return(i);
}
