/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  findmod()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>

extern char *info_str();

/*
 * f i n d m o d
 */
char *findmod(modname, infoname)
  register char *modname;
  char          *infoname;
{
  static char   path[256];
  register char *mod, *cp;

  if ((cp = rindex(infoname, '/')) != NULL)
    infoname = cp + 1;

  if (info_str(infoname, path, sizeof(path)) != NULL)
    modname = path;

  if ((cp = rindex(modname, '/')) != NULL)
    cp++;
  else
    cp = modname;

  if ((mod = (char *) modlink(cp,
                              mktypelang(MT_PROGRAM, ML_ANY))) == (char *) -1)
    (void) strcpy(path, modname);
  else {
    (void) strcpy(path, cp);
    (void) munlink(mod);
  }
  
  return(path);
}
