/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  cuserid(), chome()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <pwd.h>

extern char *getenv();

/*
 * c u s e r i d
 */
char *cuserid()
{
  static                 char username[40];
  register struct passwd *pw;
  
  if (pw = getpwuid(getuid() & 0x0ffff)) {
    strcpy(username, pw->pw_name);
    return(username);
  }
  else
    return(NULL);   /* Fehler */
}


/*
 * c h o m e
 */
char *chome()
{
  static                 char home[200];
  register struct passwd *pw;

  if (pw = getpwuid(getuid() & 0x0ffff)) {
    strcpy(home, pw->pw_dir);
    return(home);
  }
  else
    return(NULL);   /* Fehler */
}

