/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  change_passwd()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <pwd.h>
#include <strings.h>

extern struct passwd *_getpw();
extern char          *crypt();

static char          *PASS = "/h0/SYS/password";
static struct passwd passwd;
static char	     line[256];

/*
 * c h a n g e _ p a s s w d
 */
change_passwd(name, password)
  char *name, *password;
{
  char          *cryptpw;
  int           found, pos, Count;
  struct passwd *pw;
  int           pwfd, tmpfd;
  char          tmpname[256], tmp[256];
  char          *cp1, *cp2;

  /*
   * Passwort-File fuer Update oeffnen
   */
  if ((pwfd = open(PASS, S_IREAD+S_IWRITE)) < 0)
    return(-1);

  found = 0;

  /*
   * zunaechst suchen wir im Password-File den Eintrag fuer den User
   */
  while (pos = lseek(pwfd, 0, 1), (Count = readln(pwfd, line, BUFSIZ)) > 0) {
    line[Count] = '\0';
    pw = _getpw(&passwd, line);

    if (pw && (!_strccmp(name, pw->pw_name))) {
      found = 1;
      break;
    }
  }

  if (!found)
    return(-1);

  /*
   * erstes Komma suchen (danach steht das Passwort)
   */
  if (!(cp1 = index(line, ','))) {
    close(pwfd);
    return(-1);
  }

  if (!(cp2 = index(cp1+1, ','))) {
    close(pwfd);
    return(-1);
  }

  if (strlen(password))
    if (strlen(pw->pw_passwd) < 2)
      cryptpw = crypt(password, _rnd_salt());
    else
      cryptpw = crypt(password, pw->pw_passwd);

  if (cp2-cp1 == 15) {
    /*
     * Passwort einkopieren
     */
    for (cp1 += 1; cp1 < cp2; cp1++)
      *cryptpw++ = *cp1;

    lseek(pwfd, -Count, 1);
    writeln(pwfd, line, strlen(line));
    close(pwfd);
    return(0);
  }
  else {
    _ss_lock(pwfd, -1);
    lseek(pwfd, 0, 0);

    sprintf(tmpname, "/dd/pwXXXXXX");
    mktemp(tmpname);

    if ((tmpfd = creat(tmpname, S_IREAD+S_IWRITE)) < 0) {
      close(pwfd);
      return(-1);
    }

    while (lseek(pwfd, 0, 1) != pos) {
      Count = readln(pwfd, tmp, BUFSIZ);
      writeln(tmpfd, tmp, Count);
    }

    write(tmpfd, line, cp1-line+1);
    if (strlen(password))
      write(tmpfd, cryptpw, strlen(cryptpw));

    /*
     * ein bisschen trickreich: wir schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(pwfd, tmp, BUFSIZ);

    while ((Count = readln(pwfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(pwfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(pwfd, tmp, Count);
    close(tmpfd);
    _ss_size(pwfd, lseek(pwfd, 0, 1));
    close(pwfd);

    unlink(tmpname);
    return(0);
  }
}
