/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  change_grppasswd()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <grp.h>
#include <strings.h>

extern struct group  *_getgr();
extern char          *crypt();

static struct group  group;
static char	     line[256];

/*
 * c h a n g e _ g r p p a s s w d
 */
change_grppasswd (name, password)
  char *name, *password;
{
  char          *cryptpw;
  int           found, pos, Count;
  struct group  *gr;
  int           grfd, tmpfd;
  char          tmpname[256], tmp[256];
  char          *cp1, *cp2;

  /*
   * Group-File fuer Update oeffnen
   */
  if ((grfd = open(GROUP, S_IREAD+S_IWRITE)) < 0)
    return(-1);

  found = 0;

  /*
   * zunaechst suchen wir im Password-File den Eintrag fuer den User
   */
  while (pos = lseek(grfd, 0, 1), (Count = readln(grfd, line, BUFSIZ)) > 0) {
    line[Count] = '\0';
    gr = _getgr(&group, line);

    if (gr && (!_strccmp(name, gr->gr_name))) {
      found = 1;
      break;
    }
  }

  if (!found)
    return(-1);

  /*
   * erstes Colon suchen (danach steht das Passwort)
   */
  if (!(cp1 = index(line, ':'))) {
    close(grfd);
    return(-1);
  }

  if (!(cp2 = index(cp1+1, ':'))) {
    close(grfd);
    return(-1);
  }

  if (strlen(password))
    if (strlen(gr->gr_passwd) < 2)
      cryptpw = crypt(password, _rnd_salt());
    else
      cryptpw = crypt(password, gr->gr_passwd);

  if (cp2-cp1 == 15) {
    /*
     * Passwort einkopieren
     */
    for (cp1 += 1; cp1 < cp2; cp1++)
      *cryptpw++ = *cp1;

    lseek(grfd, -Count, 1);
    writeln(grfd, line, strlen(line));
    close(grfd);
    return(0);
  }
  else {
    _ss_lock(grfd, -1);
    lseek(grfd, 0, 0);

    sprintf(tmpname, "/dd/grXXXXXX");
    mktemp(tmpname);

    if ((tmpfd = creat(tmpname, S_IREAD+S_IWRITE)) < 0) {
      close(grfd);
      return(-1);
    }

    while (lseek(grfd, 0, 1) != pos) {
      Count = readln(grfd, tmp, BUFSIZ);
      writeln(tmpfd, tmp, Count);
    }

    write(tmpfd, line, cp1-line+1);
    if (strlen(password))
      write(tmpfd, cryptpw, strlen(cryptpw));

    /*
     * ein bisschen trickreich: wir schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(grfd, tmp, BUFSIZ);

    while ((Count = readln(grfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(grfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(grfd, tmp, Count);
    close(tmpfd);
    _ss_size(grfd, lseek(grfd, 0, 1));
    close(grfd);

    unlink(tmpname);
    return(0);
  }
}
