/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  _bootdrive(), ddfopen()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>

/*
 * _ b o o t d r i v e
 */
char *_bootdrive()
{
  static char    drv[33];
  register short *init_mod;
  register char  *drive;
	
  if ((init_mod = (short *) modlink("init", mktypelang(MT_SYSTEM, ML_ANY))) ==
      (short *) -1)
    return(NULL);

  if (drive = (char *) init_mod + *(init_mod + 0x20))
    strcpy(drv, drive);
  else {
    munlink(init_mod);
    return(NULL);
  }

  munlink(init_mod);
  return(drv);
}

/*
 * d d f o p e n
 */
FILE *ddfopen(fn, fname, mode, boot)
  register char *fn;
  register char *fname;
  register char *mode;
  int           boot;
{
  register FILE *fp;
  register char *drv;

  if (!boot) {
    strcpy(fname, "/dd/");
    strcat(fname, fn);

    if (fp = fopen(fname, mode))
      return(fp);
  }

  if (drv = _bootdrive()) {
    strcpy(fname, drv);
    strcat(fname, "/");
    strcat(fname, fn);
    return(fopen(fname, mode));
  }
  else
    return(NULL);
}
