/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  atime()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim and
 |                           Ulli Dessauer, Germering
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */


#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <strings.h>

extern char *getenv();

static char *month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"} ;
static char *day[]   = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

/*
 * g e t t z
 */
char *gettz(tm)
  register struct tm *tm;
{
  char          *tz;
  static char   tzbuf[20];

  tzbuf[0] = '\0';
  
  if ((tz = getenv("TZ")) == NULL)
    return(tzbuf);
  
  (void) strncpy(tzbuf, tz, 3);
  tzbuf[3] = '\0';

  if (tm->tm_isdst == 1)
    (void) strcat(tzbuf, " DST");

  return(tzbuf);
}
  
/*
 * a t i m e
 */
char *atime(tp)
  time_t *tp;
{
  struct tm   *tm;
  static char timestr[40];
   
  tm = localtime(tp);
  
  (void) sprintf(timestr, "%3.3s %3.3s %2d, %4d %02d:%02d:%02d %s (%s)",
                          day[tm->tm_wday], month[tm->tm_mon], 
                          tm->tm_mday, tm->tm_year+1900, 
                          tm->tm_hour, tm->tm_min, tm->tm_sec,
                          gettz(tm), day[tm->tm_wday]);

  return(timestr);
}


/*
 * g t i m e
 */
char *gtime(tp)
  time_t *tp;
{
  struct tm   *tm;
  static char timestr[40];
   
  tm = gmtime(tp);
  
  (void) sprintf(timestr, "%3.3s %3.3s %2d, %4d %02d:%02d:%02d GMT",
                          day[tm->tm_wday], month[tm->tm_mon], 
                          tm->tm_mday, tm->tm_year+1900, 
                          tm->tm_hour, tm->tm_min, tm->tm_sec);
                          

  return(timestr);
}
