#include <signal.h>

#define OSK_V2_3


#ifdef OSK_V2_2
/*
 * WARNING: Alarms don't work properly in OSK Version 2.2. Sometimes
 *          the kernel "forgets" an alarm.
 */

extern int setalarm(), delalarm();

/*
 * a l a r m
 */
int alarm(time)
  int time;
{
  if (_delalarm() < 0)      /* zunaechst Alarm loeschen */
    return(-1);

  if (time == 0)            /* Bei Time == 0 nur Alarm loeschen */
    return(0);
  
  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }

  return(_setalarm(time));
}  
  
/*
 * r a l a r m
 */
int ralarm(reptime)
  int reptime;
{
  if (_delalarm() < 0)      /* zunaechst Alarm loeschen */
    return(-1);

  if (reptime == 0)         /* Bei Time == 0 nur Alarm loeschen */
    return(0);
  
  if (!(reptime & 0x80000000)) {
    reptime <<= 8;          /* Zeit wird in 256tel Sekunden angegeben */
    reptime |= 0x80000000;  /* Flag fuer 1/256 Sekunden */
  }

  return(_setrepalarm(reptime));
}
#endif


#ifdef OSK_V2_3
static int alarm_id = 0;

/*
 * a l a r m
 */
int alarm(time)
  int time;
{
  if (alarm_id != 0) {
    alm_delete(alarm_id);
    alarm_id = 0;
  }

  if (time == 0)            /* only delete alarm */
    return(0);

  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }
  
  if ((alarm_id = alm_set(SIGALRM, time)) == -1) {
    alarm_id = 0;
    return(-1);
  }

  return(0);
}


/*
 * r a l a r m
 */
int ralarm(time)
  int time;
{
  if (alarm_id != 0) {
    alm_delete(alarm_id);
    alarm_id = 0;
  }

  if (time == 0)
    return(0);

  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }
  
  if ((alarm_id = alm_cycle(SIGALRM, time)) == -1) {
    alarm_id = 0;
    return(-1);
  }

  return(0);
}
#endif
