


     PUZZLE15(6)              OS9/68000 V2.1               PUZZLE15(6)



     NAME
          puzzle15 - simulate a well known toy with many variations

     SYNOPSIS
          ppuuzzzzllee1155 [<width[x<height>]] [movemethod] [cursormethod]
          [facemethod]

     DESCRIPTION
          _P_u_z_z_l_e_1_5 simulates a game that is available in many toy
          shops. This computerized version is crt-oriented and offers
          fewer possibilities for cheating.
          When invoked without arguments _p_u_z_z_l_e_1_5 presents a 4 by 4
          grid with 15 numbered tiles and one empty square.  The tiles
          are not ordered in sequence.  The tiles adjacent to the
          empty square can exchange places with the empty square. This
          is done by indicating the direction that the empty square is
          to move with the vi(1) cursor keys (k for up, j for down, h
          for left and l for right).
          The intention of the game is to rearrange the tiles in their
          ``natural'' sequence.

          The program keeps track of the time and the number of moves
          used.  This makes it possible to arrange competitions where
          time, or the number of moves used determines the winner.

          The program ends when the tiles are arranged in sequence, or
          when you type your interrupt character (usually ctrl-C or
          break). On computers that lack good support for keyboard
          interrupts a key can be selected that will terminate the
          program. (This is a compile-time option.)

     VARIATIONS
          The look and feel of the program can be altered by
          specifying different dimensions for the array, the way that
          the tile to move is selected (movemethod), the keys that
          specify where the cursor is to go (cursormethod) and the
          faces that are shown on the tiles (facemethod).

     DIMENSIONS
          The dimensions of the board can be varied within the limits
          of your terminal screen. To obtain a square array a single
          numeric argument is required. _P_u_z_z_l_e_1_5 _3 presents a 3x3
          array with 8 numbered tiles. With numbered tiles it is not
          possible to extend the array beyond 10 by 10, because only
          two digits are used to identify each tile.

          To obtain a non-square array an argument that consists of a
          number, the character 'x' and another number must be
          supplied.  _P_u_z_z_l_e_1_5 _6_x_3 presents a grid that is 6 columns
          wide and 3 rows high with 17 numbered tiles.

     MOVEMETHODS
          The default movemethod is to indicate the direction that the
          empty (blank) field is to move. This is called _m_o_v_e_b_l_a_n_k.
          There are two other methods that can be selected by an
          argument on the command line.
          _M_o_v_e_t_i_l_e tells _p_u_z_z_l_e_1_5 that you want to indicate the
          direction that an adjacent tile is to be moved. This is



     Page 1                                          (printed 3/20/89)






     PUZZLE15(6)              OS9/68000 V2.1               PUZZLE15(6)



          equivalent to reversal of the directions of the cursor keys.
          _S_e_l_e_c_t_t_i_l_e tells _p_u_z_z_l_e_1_5 that you want to indicate the new
          position of the empty field by moving the cursor to that
          position and then typing a <space>, or <return> (or whatever
          you like). In this way you can move several tiles in one
          blow.

     CURSORMETHODS
          The default way to move the cursor or the empty field is to
          use the vi(1) cursor keys.
          On some computers it is possible to specify _a_r_r_o_w_k_e_y_s, which
          tells _p_u_z_z_l_e_1_5 to use the arrow keys of your terminal to
          specify a move.
          If you specify _n_u_m_b_e_r_k_e_y_s on the command line, _p_u_z_z_l_e_1_5 will
          use '8' for up, '2' for down, '4' for left and '6' for
          right.  this corresponds to arrows on the numeric key pad of
          most personal computers.
          Another way to specify where the empty field is to go is
          obtained by specifying _f_a_c_e_k_e_y_s on the command line. In this
          mode you move the empty field to a new position by typing
          the character(s) shown on the tile that currently occupies
          that position. _F_a_c_e_k_e_y_s implies use of the movemethod
          _s_e_l_e_c_t_t_i_l_e. If the _f_a_c_e_k_e_y_s cursormethod is used with
          numbered tiles, some tile numbers are shown with leading
          zero. To select such a tile a leading zero is required.
          Tiles that are labeled with a single digit can be selected
          with that digit, or with a leading zero followed by that
          digit.
          Finally you can specify your own cursor movement keys with
          _k_e_y_s <_u_p><_d_o_w_n><_l_e_f_t><_r_i_g_h_t> on the command line. <Up> is
          the key that you will use to move up, etc.

     FACEMETHODS
          The default way that _p_u_z_z_l_e_1_5 uses to identify the tiles is
          to number them. If you prefer tiles that are marked with
          letters you must specify _a_l_p_h_a_f_a_c_e_s on the command line.
          _P_u_z_z_l_e_1_5 will now use the lower-case letters a..z to
          identify the tiles.
          Similarly, if you specify _n_u_m_b_e_r_a_l_p_h_a_f_a_c_e_s _p_u_z_z_l_e_1_5 will use
          the digits 0..9 followed by the lower-case letters a..z to
          identify the tiles.
          _A_l_p_h_a_n_u_m_b_e_r_f_a_c_e_s selects the lower-case letters a..z
          followed by the digits 0..9.
          Finally, you can specify the characters to use on the
          command line with _f_a_c_e_s <_f_a_c_e_c_h_a_r_a_c_t_e_r_s>. The order in
          <_f_a_c_e_c_h_a_r_a_c_t_e_r_s> will be used to determine when the tiles
          are ordered.

     EXAMPLES
          _p_u_z_z_l_e_1_5 _f_a_c_e_s '_1_2_3_4_5_6_7_8_9_0_q_w_e_r_t_y_u_i_o_p_a_s_d_f_g_h_j_k_l;_z_x_c_v_b_n_m,.'
          _1_0_x_4
          creates a 10 by 4 array filled with the symbols of a
          typewriter keyboard. The position to achieve is the ordering
          of the keys on the typewriter. Quoting is necessary to
          prevent the shell from treating the ``;'' as a special
          character. By adding the option _f_a_c_e_k_e_y_s the program turns
          into a tough typing tutor, especially if you decide not to
          take your eyes off the screen.



     Page 2                                          (printed 3/20/89)






     PUZZLE15(6)              OS9/68000 V2.1               PUZZLE15(6)



     DIAGNOSTICS
          An unknown keyword or an illegal combination of keywords on
          the command line generates a complete list of possible
          keywords and restrictions on their combinations.
          If you type an undefined key during the game, the program
          lists the keys that are valid.
          On startup fatal diagnostics from the curses screen handling
          package are possible if your terminal is ill-defined.
          If the program detects an internal error a diagnostic
          starting with the letters _a_a_r_g_h: is printed. If you manage
          to get one of these, I like to know how you did it.

     AUTHOR
          P. Knoppers - knop@duteca.UUCP.
          Paul Lew added arrow keys.
          Bo Kullmar added the clock and the move counter.
          Larry Hastings suggested the selecttile method.

     COPYRIGHT
          The _p_u_z_z_l_e_1_5 program is protected by copyright (C) 1984,
          1988, 1989 by P. Knoppers. Distribution of unmodified copies
          of the program with source is unrestricted. You are not
          allowed to distribute modified copies. This is to prevent
          uncontrolled spreading of a zillion different versions. You
          can mail suggestions for improvements to me. I _m_a_y
          incorporate them in a future version.



































     Page 3                                          (printed 3/20/89)



