


     NFACCESS(8)     UNIX 5.0 (University of Illinois)	   NFACCESS(8)



     NAME
	  nfaccess - Add access	rights to a set	of Notesfiles

     SYNOPSIS
	  nfaccess access-right	topic [	topic ... ]

     DESCRIPTION
	  Nfaccess simplifies the task of adding an access-right to
	  many notesfiles.  The	function is somewhat analagous to that
	  of chmod(1).

	  The access-right specifies a user, group or system and the
	  permissions to be granted.  The format is:

		    <access-right> ::= [<type>:]name=<mode>
		    <type>    ::= {User, user, Group, group, System, system}
		    <mode>    ::= {d, r, w, a, n}+

	  The type specification can be	omitted; when it is omitted,
	  the name is assumed to be a user.  The mode is additive.  A
	  mode of ``rw'' specifies read	and write.  The	``n'' mode
	  specifies null access.

	  The new access right is inserted in each specified
	  notesfiles access list.  If the user/group/system already
	  has an entry,	the old	entry is replaced with the new entry.

	  All users are	allowed	to run this program.  The changes are
	  only applied to notesfiles for which the executing user is a
	  director.

	  This program lives in	the notesfile utility directory,
	  typically ``/usr/spool/notes/.utilities''.

	  To automatically add specific	access-rights to newly created
	  notesfiles, the file ``/usr/spool/notes/.utilities/access-
	  template'' is	useful.	 If it exists, the file	contains lines
	  of acces-rights which	are added to each notesfile as it is
	  created.  If several people share the	administration of the
	  notesfile system, each can be	added to the access-lists of
	  newly	created	notesfiles by placing appropriate lines	in
	  this file.

     EXAMPLES
		    nfaccess essick=drw	/usr/spool/notes/*
		    nfaccess group:srg=rw this that other
		    nfaccess user:kolstad=rw mynotes

	  In the first example,	user `essick' is given
	  director/read/write access to	all the	notesfiles in
	  /usr/spool/notes.  Any permissions (or restrictions) he
	  might	have had before	are overridden.	 The second example



     Page 1					     (printed 2/25/88)






     NFACCESS(8)     UNIX 5.0 (University of Illinois)	   NFACCESS(8)



	  gives	group `srg' read/write access to notesfiles `this',
	  `that' and `other'.  In the final example, user `kolstad' is
	  given	read/write access to the notesfile `mynotes'.

     BUGS
	  Entries can not be removed from the access list with this
	  program.

	  Entries can not merely be augmented (``just add write
	  permission'')	with this program.

     FILES
	  /etc/passwd			     for the users name
	  /etc/group			     for the users group
	  /usr/spool/notes		     the default notesfile
					     data base

     SEE ALSO
	  mknf(8), notes(1), nfcomment(3),
	  The Notesfile	Reference Manual

     AUTHORS
	  Ray Essick (uiucdcs!essick, essick%uiuc@csnet-relay.arpa)
	  University of	Illinois at Urbana-Champaign
	  Urbana, IL






























     Page 2					     (printed 2/25/88)



