     SMAIL(8)		      XENIX System V		      SMAIL(8)



     NAME
	  smail, rmail - UUCP mailer with routing

     SYNOPSIS
	  smail	[ options ] address ...
	  rmail	[ options ] address ...

     DESCRIPTION
	  The smail/rmail program replaces /bin/rmail(1) to become the
	  UUCP mail transport mechanism.  They are links to the	same
	  executable.  rmail receives mail from	UUCP, smail introduces
	  mail into UUCP.

	  smail/rmail can work with or without sendmail(8), or another
	  intelligent mail system.  For	hosts with just	/bin/mail(1),
	  smail/rmail subsumes some of the functions of	sendmail, and
	  hands	only local mail	to /bin/mail. For hosts	with sendmail,
	  smail/rmail can act as UUCP front and	back ends to sendmail,
	  allowing sendmail to process all mail	through	the host.  As
	  distributed, 'bang' mail that	is not bound for a local
	  recipient will be passed directly to uux without calling
	  sendmail.

	  To varying degrees, smail/rmail automatically	routes the
	  addresses it processes.  smail/rmail most often routes
	  domain style addresses (i.e. user@domain), producing a UUCP
	  path (i.e. host!address) or a	local address (i.e. user), but
	  it can also reroute explicit UUCP paths.

     OPTIONS
	  -A   Print the resolved addresses.  Don't collect a message
	       or invoke a mailer.

	  -d   Be verbose and don't invoke other mailers.

	  -v   Be verbose, but still invoke other mailers.

	  -h hostname
	       Set hostname.  The default is configuration dependent,
	       but usually provided by a system	call such as
	       gethostname(2) or uname(2).

	  -H hostdomain
	       set hostdomain.	The default is configuration
	       dependent.

	  -F address
	       use address on the From:	line in	locally	generated
	       mail.

	  -p pathfile
	       Set path	database file name if not /usr/lib/uucp/paths.

	  -a aliasfile
	       For sites without sendmail, set alias database file
	       name if not in the place	defined	at compile time	(see
	       ALIASES in defs.h).  This is usually /usr/lib/aliases

	  -n namelist
	       smail supports another type of aliasing intended	for
	       full name resolution using a sorted file, namelist, of
	       name/address pairs.  This allows	mail to
	       George.P.Burdell@gatech.edu to be delivered
	       appropriately.  These aliases are by their nature very
	       simple since they are not composed of long lists	of
	       recipients for each alias.  They	are also numerous,
	       since mail to George.P.Burdell may be addressed to
	       Burdell,	G.Burdell, George.Burdell, P.Burdell,
	       G.P.Burdell, or George.P.Burdell.  This simpler form of
	       aliasing	uses the same fast searching algorithm that is
	       used for	the paths file,	so it keeps resolution time
	       manageable.

	  -q number
	       Take number as the queueing threshold.  When routing
	       mail ( -r, -R, or domain	addressed mail ) to a given
	       host, if	the cost listed	in the paths file is less than
	       the queueing threshold, then the	mail will be sent
	       immediately.  This overrides the	default	threshold (see
	       QUEUECOST in defs.h) of DEDICATED+LOW.

	  -m number
	       At most number jobs will	be handed to uux for immediate
	       delivery	by a single invocation of smail	(see
	       MAXNOQUEUE in defs.h).

	  -u uuxflags
	       Use uuxflags as the flags passed	to uux for remote
	       mail.  This overrides any of the	default	values and
	       other queueing strategies.

	  -c   Consult the paths file for the cost of the path even
	       when not	routing	the mail.  This	makes it possible to
	       use the cost information	when sending pure UUCP path
	       mail without rerouting it.

	  -r   Don't route the first component of a UUCP path (host!address)
	       in addition to routing domain addresses (user@domain).

	  -R   Reroute UUCP paths, trying successively larger
	       righthand substrings of a path until a component	is
	       recognized.

	  -l   Instead of routing a domain address, send it to the
	       local mailer for	processing.  Normally, only local
	       addresses go to the local mailer.

	  -L   Send all	addresses to the local mailer for processing,
	       including UUCP paths.

	  Most of the flags are	also compile time options, since uux
	  does not normally invoke rmail with the desired flags.
	  smail	resets any preset -l or	-L flags.  -l flag causes
	  rmail	to send	all domain addresses through the local mailer,
	  to process addresses for non UUCP domains.  The -L flag
	  causes rmail to send even explicit UUCP paths	through	the
	  local	mailer,	presumably to make use of other	transport
	  mechanisms.  In both cases, rmail defers any routing until
	  smail	gets hold it.

     ADDRESSES
	  smail/rmail understands "user@domain"	to be a	domain
	  address, "host!address" to be	a UUCP path, and anything else
	  to be	a local	address.

	  Because hostile rmail's unpredictably	interpret mixed
	  UUCP/domain addresses, smail/rmail understands "domain!user"
	  to be	a domain address, and generates	"path!domain!user"
	  when mailing to a cognate smail/rmail	host.  To distinguish
	  domain "domain!user" from UUCP "host!address", "domain"
	  contains at least one	(1) period.  Unlike the	old
	  /bin/rmail, smail/rmail gives	precedence to @	over ! when
	  parsing mixed	addresses, thus	a!b@c is parsed	as (a!b)@c,
	  rather than a!(b@c).

     ROUTING
	  Because smail/rmail is the UUCP transport mechanism, it can
	  only effect delivery on UUCP paths and local addresses;
	  domain addresses require resolution into UUCP	paths or local
	  addresses. To	resolve	a domain address, smail/rmail finds a
	  route	to the most specific part of the domain	specification
	  listed in the	routing	table.	Two degrees of resolution can
	  occur:

	       Full resolution:	smail/rmail finds a route for the
	       entire domain specification, and	tacks the user
	       specification onto the end of the UUCP path.  The
	       address can also	fully resolve to a local address (the
	       UUCP path is null).

	       Partial resolution: smail/rmail finds a route for only
	       righthand part of the domain specification, so it tacks
	       the complete address (in	the form domain!user) onto the
	       end of the UUCP path.  Since this syntax	is not widely
	       understood, UUCP	gateways listed	in the path database
	       must install new	UUCP software, either smail/rmail or
	       new sendmail configuration files	(or both).

	  It is	an error if a partially	resolved address routes	to the
	  local	host (a	null UUCP path), since according to the
	  routing table, the local host	is responsible for resolving
	  the address more fully.

	  The -r flag causes smail/rmail to attempt to route the first
	  component of a UUCP path, probably so	it can impress people
	  with how many	UUCP hosts it knows.  If this fails, it	passes
	  the unrouted address to uux, in case the path	database is
	  not complete.	 The -R	flag causes smail/rmail	to take	a UUCP
	  path and route the rightmost component of the	path (save the
	  user name) possible.	This is	mostly for hosts that have
	  very up-to-date routing tables.

	  If a route cannot be discerned from the available routing
	  database, then one more attempt to route the mail is made by
	  searching for	an entry in the	database for a route to	a
	  smart-host. If this entry exists, then the mail will be
	  forwarded along that route to	be delivered.  This allows a
	  host to depend on another, presumably	better informed, host
	  for delivering its mail.  This kind of arrangement should be
	  worked out, in advance, with the smart-host's	administrator.

	  After	smail/rmail resolves an	address, it reparses it	to see
	  if it	is now a UUCP path or local address.  If the new
	  address turns	out to be another domain address, smail
	  complains because we don't like to resolve more than once.
	  This error occurs when an address partially resolves the
	  local	host.

	  By default, smail will not alter the explicit	bang path
	  routing of any mail message.	If the stated path is
	  unuseable, (i.e., the	next hop host is unknown) then smail
	  will apply ALWAYS routing, and attempt to deliver the	mail
	  to the potentially new address.  If this fails too, then
	  REROUTE routing will be applied to the address, and another
	  attempt to deliver is	made.  Lastly, an attempt to find a
	  path to a better informed host smart-host will be made and
	  the mail passed to that host.

     FROMMING
	  smail/rmail collapses	From_ and >From_ lines to generate a
	  simple from argument,	which it can pass to sendmail or use
	  to create its	own "From" line.  The rule for fromming	is:
	  concatenate each "remote from" host (separating them by
	  !'s),	and tack on the	address	on the last From_ line;	if
	  that address is in user@domain format, rewrite it as
	  domain!user; ignore host or domain if	either is simply the
	  local	hostname.  It also removes redundant information from
	  the From_ line.  For instance:

			 ...!myhost!myhost.mydomain!...

	  becomes

				 ...!myhost!...

	  Leading occurrences of the local host	name are elided	as
	  well.

	  smail/rmail generates	it own From_ line, unless it is
	  feeding sendmail, which is happy with	the -ffrom argument.
	  For UUCP bound mail, smail/rmail generates a "remote from
	  hostname", where hostname is the UUCP	hostname (not the
	  domain name),	so that	From_ can indicate a valid UUCP	path,
	  leaving the sender's domain address in From:.

     HEADERS
	  Certain headers, To:,	From:, Date, etc., are required	by
	  RFC822.  If these headers are	absent in locally generated
	  mail,	they will be inserted by smail.	 Also, a line of trace
	  information, called a	Received: line,	will be	inserted at
	  the top of each message.

     UNDELIVERABLE MAIL"
	  Although nobody likes	to have	a mail message fail to reach
	  its intended destination, it somtimes	happens	that way.
	  Mail that is found to	be undeliverable (i.e.,	unknown	user
	  or unknown host) will	be returned to the sender.

     FILES
	  /usr/lib/uucp/paths	   ascii path database
	  /usr/lib/aliases	   ascii alias database
	  /usr/spool/uucp/mail.log	log of mail
	  /tmp/mail.log		   record of mail

     SUPPORT
	  Enhancements,	enhancement requests, trouble reports, etc.,
	  should be sent to

			   uucp-problem@Stargate.COM.


     SEE ALSO
	  uux(1), paths(8), aliases(8)
	  sendmail(8)
	  binmail(1) on	BSD systems only
	  mail(1) on System V systems

     VERSION
	  @(#)smail.8	 2.5 (smail) 9/15/87

