


     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



     NAME
	  pathalias, makedb, arpatxt - mail routing tools

     SYNOPSIS
	  pathalias [ -ivcDf ] [ -t link ] [ -l	host ] [ -a host ]
	  [-d link ] [ files ...	]

	  makedb [ -a ]	[ -o dbmfile ] [ files ... ]

	  arpatxt [ -@fi ] [ -g	gateway	] [ -p privatefile ]
	  [-d directory ] [ files ... ]

     DESCRIPTION
	  Pathalias computes  the  shortest  paths  and	 corresponding
	  routes  from	one host (computer system) to all other	known,
	  reachable hosts.  Pathalias reads host-to-host  connectivity
	  information  on  standard  input  or in the named files, and
	  writes a list	of host-route pairs on the standard output.

	  Here are the pathalias options:

	  -i	Ignore case:  map all host names to  lower  case.   By
		default, case is significant.

	  -c	Print costs: print the path  cost  before  each	 host-
		route pair.

	  -v	Verbose: report	some statistics	on the standard	 error
		output.

	  -D	Terminal domains: domain members are terminal.

	  -f	First hop cost:	the printed cost is the	 cost  to  the
		first relay in a path, instead of the cost of the path
		itself;	implies	(and overrides)	the -c option.

	  -l host
		Set local host name to host.   By  default,  pathalias
		discovers  the	local  host name in a system-dependent
		way.

	  -a host
		Avoid host; penalize all links out of host by a	 small
		amount.	 The -a	option is cumulative.

	  -d arg
		Declare	a dead link, host, or network.	If arg	is  of
		the  form  ``host-1!host-2,''  the link	from host-1 to
		host-2 is treated as an	 extremely  high  cost	(i.e.,
		DEAD)  link.   If arg is a single host name, that host
		is treated as dead and is used as a relay host of last
		resort	on  any	 path.	 If arg	is a network name, the



     Page 1					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



		network	requires a gateway.

	  -t arg
		Trace input for	link, host or network on the  standard
		error output.  The form	of arg is as above.

	  Makedb takes pathalias output	and creates or	appends	 to  a
	  dbm(3) database.

	  Here are the makedb options:

	  -a	Append to an existing  database;  by  default,	makedb
		truncates the database.

	  -o dbmfile
		Identify the output file base name.

	  Arpatxt converts the Internet	 hosts	table  hosts.txt  into
	  pathalias input.

	  Here are the arpatxt options:

	  -@	Generate pathalias  input  that	 specifies  `@'	 style
		addressing.  The default is to produce pathalias input
		that specifies `!' style addressing.

	  -f	``Filter mode''	- write	output on  stdout.   Normally,
		arpatxt	 writes	 the description of each domain	into a
		separate file.

	  -i	Map output to lower case.

	  -g arg
		Declare	a gateway  to  the  Internet  or  one  of  its
		subdomains.   If  arg  contains	 one or	more dots, the
		left-hand side component  that	contains  no  dots  is
		declared  a  gateway to	the domain to the right	of the
		dot.  Otherwise, arg is	 declared  a  gateway  to  the
		Internet as a whole.

	  -p privatefile
		Privatefile  contains  a  list	of  host  names	  that
		conflict with other names.

	  -d directory
		Write output files in directory.

	Pathalias Input	Format
	  A line beginning with	white space  continues	the  preceding
	  line.	 Anything following `#'	on an input line is ignored.

	  A list of host-to-host connections consists  of  a  ``from''



     Page 2					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



	  host	in  column  1,	followed by white space, followed by a
	  comma-separated list of ``to'	hosts, called links.   A  link
	  may be preceded or followed by a network character to	use in
	  the route.  Valid network characters are `!' (default), `@',
	  `:',	and  `%'.   A link (and	network	character, if present)
	  may be followed  by  a  ``cost''  enclosed  in  parentheses.
	  Costs	 may  be  arbitrary  arithmetic	 expressions involving
	  numbers, parentheses,	`+', `-', `*', and `/'.	 The following
	  symbolic costs are recognized:

	       LOCAL	   25	(local-area network connection)
	       DEDICATED   95	(high speed dedicated link)
	       DIRECT	  200	(toll-free call)
	       DEMAND	  300	(long-distance call)
	       HOURLY	  500	(hourly	poll)
	       EVENING	 1800	(time restricted call)
	       DAILY	 5000	(daily poll, also called POLLED)
	       WEEKLY	30000	(irregular poll)

	  In addition,	DEAD  is  a  very  large  number  (effectively
	  infinite),  HIGH  and	 LOW  are  -5 and +5 respectively, for
	  baud-rate or quality bonuses/penalties, and FAST is -80, for
	  adjusting  costs  of links that use high-speed (9.6 Kbaud or
	  more)	modems.	 These symbolic	costs represent	 an  imperfect
	  measure  of  bandwidth,  monetary  cost,  and	 frequency  of
	  connections.	For most mail  traffic,	 it  is	 important  to
	  minimize  the	number of hosts	in a route, thus, e.g.,	HOURLY
	  * 24 is much larger than DAILY.  If  no  cost	 is  given,  a
	  default of 4000 is used.

	  For the most part, arithmetic	expressions that mix  symbolic
	  constants  other  than  HIGH,	 LOW,  and FAST	make no	sense.
	  E.g.,	if a host calls	a local	 neighbor  whenever  there  is
	  work,	 and  additionally  polls  every  evening, the cost is
	  DIRECT, not DIRECT+EVENING.

	  Some examples:

	       down	 princeton!(DEDICATED),	tilt,
			 %thrash(LOCAL)
	       princeton topaz!(DEMAND+LOW)
	       topaz	 @rutgers(LOCAL+1)

	  If a link is encountered  more  than	once,  the  least-cost
	  occurrence  dictates	the cost and network character.	 Links
	  are treated as bidirectional but asymmetric: for  each  link
	  declared in the input, a DEAD	reverse	link is	assumed.

	  If the  ``to''  host	in  a  link  is	 surrounded  by	 angle
	  brackets, the	link is	considered terminal, and further links
	  beyond this one are heavily penalized.  E.g.,	with input




     Page 3					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



	       seismo	 <research>(10), research(100),	ihnp4(10)
	       research	 allegra(10)
	       ihnp4	 allegra(50)

	  the path from	seismo to research is  direct,	but  the  path
	  from	seismo to allegra uses ihnp4 as	a relay, not research.
	  The way to think  of	this  is  to  imagine  two  copies  of
	  research,  one that's	cheap to get to, but has no neighbors,
	  and one that's expensive  to	get  to,  but  has  neighbors.
	  (This	 is  an	 exception  to	the  ``least-cost  link'' rule
	  above.)

	  The set of names by which a host is known to	its  neighbors
	  is called its	aliases.  Aliases are declared as follows:

	       name = alias, alias ...

	  The name used	in the route to	or through  aliased  hosts  is
	  the  name  by	 which the host	is known to its	predecessor in
	  the route.

	  Fully	connected networks, such as the	ARPANET	 or  a	local-
	  area network,	are declared as	follows:

	       net = {host, host, ...}

	  The host-list	may be	preceded  or  followed	by  a  routing
	  character, and may be	followed by a cost:

	       princeton-ethernet = {down, up, princeton}!(LOCAL)
	       ARPA = @{sri-unix, mit-ai, su-score}(DEDICATED)

	  The routing character	used in	a route	to a network member is
	  the one encountered when ``entering''	the network.  See also
	  the sections on gateways and domains .

	  Connection data may be given	while  hiding  host  names  by
	  declaring

	       private {host, host, ...}

	  Pathalias will not generate routes for  private  hosts,  but
	  may  produce	routes	through	 them.	The scope of a private
	  declaration extends from the declaration to the end  of  the
	  input	 file in which it appears, or to a private declaration
	  with an empty	host list, whichever comes first.  The	latter
	  scope	 rule  offers a	way to retain the semantics of private
	  declarations when reading from the standard input.

	  Dead hosts, links, or	networks may be	presented in the input
	  stream by declaring




     Page 4					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



	       dead {arg, ...}

	  where	arg has	the same  form	as  the	 argument  to  the  -d
	  option.

	Output Format
	  A list of  host-route	 pairs	is  written  to	 the  standard
	  output,  where  route	 is  a string appropriate for use with
	  printf(3), e.g.,

	       rutgers	 princeton!topaz!%s@rutgers

	  The ``%s'' in	the route string should	 be  replaced  by  the
	  user	name  at the destination host.	(This task is normally
	  performed by a mailer.)

	  Except for domains, the name of a network is never  used  in
	  routes.  Thus, in the	earlier	example, the path from down to
	  up would be ``up!%s,'' not ``princeton-ethernet!up!%s.''

	Gateways
	  A network is represented by  a  pseudo-host  and  a  set  of
	  network members.  Links from the members to the network have
	  the weight given in the  input,  while  the  cost  from  the
	  network  to  the  members is zero.  If a network is declared
	  dead,	the member-to-network links  are  marked  dead,	 which
	  effectively	prohibits  access  to  the  network  from  its
	  members.

	  However, if the input	also shows an explicit link  from  any
	  host	to  the	 network,  then	 that  host  can  be used as a
	  gateway.  (In	particular, the	gateway	need not be a  network
	  member.)

	  E.g.,	if CSNET is declared dead and the input	contains

	       CSNET = {...}
	       csnet-relay	   CSNET

	  then routes  to  CSNET  hosts	 will  use  csnet-relay	 as  a
	  gateway.

	Domains
	  A network whose name begins with `.'	is  called  a  domain.
	  Domains  are	presumed  to  require gateways,	i.e., they are
	  DEAD.	 The route given by a path through a domain is similar
	  to  that  for	 a network, but	here the domain	name is	tacked
	  onto the end of the next host.  Subdomains are permitted.

	  E.g.,

	       harvard	 .EDU	   # harvard is	gateway	to .EDU	domain



     Page 5					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



	       .EDU	 = {.BERKELEY, .UMICH}
	       .BERKELEY = {ernie}

	  yields

	       ernie	 ...!harvard!ernie.BERKELEY.EDU!%s

	  Output is given for the nearest gateway to a	domain,	 e.g.,
	  the example above gives

	       .EDU	 ...!harvard!%s

	  Output is given for a	subdomain if it	has a different	 route
	  than	its  parent domain, or if all its ancestor domains are
	  private.

	  If the -D option is given on	the  command  line,  pathalias
	  treats  a link from a	domain to a host member	of that	domain
	  as terminal.	This discourages the use of routes that	use  a
	  domain member	as a relay.

	Databases
	  Makedb builds	a dbm(3) database from the standard  input  or
	  from	the  named files.  Input is expected to	be sequence of
	  ASCII	records, each consisting of a key  field  and  a  data
	  field	separated by a single tab.  If the tab is missing, the
	  data field is	assumed	to be empty.

     FILES ET AL.
	  /usr/local/lib/palias.{dir,pag}     default dbm output
	  newsgroup comp.mail.maps	      likely location of  some
	  input	files
	  getopt(3), available from comp.sources.unix archives (if not
	  in the C library).

     BUGS
	  Terminal nets	are not	implemented.

	  The -i option	should be the default.

	  The order of arguments is significant.   In  particular,  -i
	  and -t should	appear early.

	  Pathalias can	generate hybrid	(i.e. ambiguous) routes, which
	  are  abhorrent  and  most  certainly	should not be given as
	  examples in the manual entry.	 Experienced  mappers  largely
	  shun	`@' when preparing input; this is historical, but also
	  reflects UUCP's facile syntax	for source routes.

	  Multiple `@'s	in routes are loathsome, so pathalias  resorts
	  to  the ``magic %'' rule when	necessary.  This convention is
	  not documented anywhere, including here.



     Page 6					    (printed 12/28/87)






     PATHALIAS(1)	  Public Domain	(10/4/87)	  PATHALIAS(1)



	  The -D option	elides insignificant routes to domain members.
	  This	is  benign,  perhaps  even  beneficial,	but confusing,
	  since	  the	behavior   is	undocumented   and    somewhat
	  unpredictable.

     SEE ALSO
	  P. Honeyman and S.M. Bellovin, ``PATHALIAS or	The  Care  and
	  Feeding  of  Relative	 Addresses,''  in  Proc. Summer	USENIX
	  Conf., Atlanta, 1986.














































     Page 7					    (printed 12/28/87)




