#define	UTMP_FILE "/dd/SYS/utmp"
#define	WTMP_FILE "/dd/SYS/wtmp"

#define	ut_name	ut_user

struct utmp {
  char   ut_user[33];           /* User login name                */
  char   ut_id[4];              /* /etc/lines id (usually line #) */
  char   ut_line[33];           /* device name (console, lnxx)    */
  short  ut_pid;                /* process id                     */
  short  ut_uid, ut_gid;        /* User ID, Group ID              */

#ifdef notdef
  struct exit_status {
    short e_termination;        /* Process termination status     */
    short e_exit;		/* Process exit status            */
  } ut_exit;			/* The exit status of a process
                                 * marked as DEAD_PROCESS.
                                 */
#endif

  int    ut_baud;               /* Baud rate                      */
  short  ut_type;               /* type of entry                  */
  time_t ut_time;               /* time entry was made            */
  char   ut_status[10];         /* Flags                          */
} ;

/*
 * Definitions for ut_type
 */
#define	EMPTY         0
#define LOGOFF        0
#define	BOOT_TIME     1
#define	USER_PROCESS  2
#define	OLD_TIME      3
#define	NEW_TIME      4
#define	INIT_PROCESS  5         /* Process spawned by "init"           */
#define	LOGIN_PROCESS 6         /* A "getty" process waiting for login */
#define	RUN_LVL       7         /* A user process                      */
#define	DEAD_PROCESS  8
#define	ACCOUNTING    9

#define	UTMAXTYPE     ACCOUNTING  /* Largest legal value of ut_type */

/*
 * Special strings or formats used in the "ut_line" field when
 * accounting for something other than a process.
 * No string for the ut_line field can be more than 32 chars +
 * a NULL in length.
 */
#define	RUNLVL_MSG  "run-level %c"
#define	BOOT_MSG    "system boot"
#define	OTIME_MSG   "old time"
#define	NTIME_MSG   "new time"

extern int         _utmp_write();
extern int         setwhoent();
extern int         endwhoent();
extern struct utmp *getwhoent();

extern struct utmp *getutent();
extern struct utmp *getutid();
extern struct utmp *getutline();
extern int         pututline();
extern int         setutent();
extern int         endutent();
extern int         utmpname();

