/*
**	term.h -- Definition of struct term
*/

#ifndef SGTTY
#    include <ncurses.h>
#endif

#ifdef SINGLE
#	define CUR _first_term.
#else
#	define CUR cur_term->
#endif


#define auto_left_margin               CUR Booleans[0]
#define auto_right_margin              CUR Booleans[1]
#define beehive_glitch                 CUR Booleans[2]
#define eat_newline_glitch             CUR Booleans[3]
#define erase_overstrike               CUR Booleans[4]
#define generic_type                   CUR Booleans[5]
#define hard_copy                      CUR Booleans[6]
#define has_meta_key                   CUR Booleans[7]
#define has_status_line                CUR Booleans[8]
#define insert_null_glitch             CUR Booleans[9]
#define memory_above                   CUR Booleans[10]
#define memory_below                   CUR Booleans[11]
#define move_insert_mode               CUR Booleans[12]
#define move_standout_mode             CUR Booleans[13]
#define over_strike                    CUR Booleans[14]
#define status_line_esc_ok             CUR Booleans[15]
#define teleray_glitch                 CUR Booleans[16]
#define tilde_glitch                   CUR Booleans[17]
#define transparent_underline          CUR Booleans[18]
#define xon_xoff                       CUR Booleans[19]
#define columns                        CUR Numbers[0]
#define init_tabs                      CUR Numbers[1]
#define lines                          CUR Numbers[2]
#define lines_of_memory                CUR Numbers[3]
#define magic_cookie_glitch            CUR Numbers[4]
#define padding_baud_rate              CUR Numbers[5]
#define virtual_terminal               CUR Numbers[6]
#define width_status_line              CUR Numbers[7]
#define appl_defined_str               CUR Strings[0]
#define back_tab                       CUR Strings[1]
#define bell                           CUR Strings[2]
#define box_chars_1                    CUR Strings[3]
#define box_chars_2                    CUR Strings[4]
#define box_attr_1                     CUR Strings[5]
#define box_attr_2                     CUR Strings[6]
#define carriage_return                CUR Strings[7]
#define change_scroll_region           CUR Strings[8]
#define clear_all_tabs                 CUR Strings[9]
#define clear_screen                   CUR Strings[10]
#define clr_eol                        CUR Strings[11]
#define clr_eos                        CUR Strings[12]
#define column_address                 CUR Strings[13]
#define command_character              CUR Strings[14]
#define cursor_address                 CUR Strings[15]
#define cursor_down                    CUR Strings[16]
#define cursor_home                    CUR Strings[17]
#define cursor_invisible               CUR Strings[18]
#define cursor_left                    CUR Strings[19]
#define cursor_mem_address             CUR Strings[20]
#define cursor_normal                  CUR Strings[21]
#define cursor_right                   CUR Strings[22]
#define cursor_to_ll                   CUR Strings[23]
#define cursor_up                      CUR Strings[24]
#define cursor_visible                 CUR Strings[25]
#define delete_character               CUR Strings[26]
#define delete_line                    CUR Strings[27]
#define dis_status_line                CUR Strings[28]
#define down_half_line                 CUR Strings[29]
#define enter_alt_charset_mode         CUR Strings[30]
#define enter_blink_mode               CUR Strings[31]
#define enter_bold_mode                CUR Strings[32]
#define enter_ca_mode                  CUR Strings[33]
#define enter_delete_mode              CUR Strings[34]
#define enter_dim_mode                 CUR Strings[35]
#define enter_insert_mode              CUR Strings[36]
#define enter_secure_mode              CUR Strings[37]
#define enter_protected_mode           CUR Strings[38]
#define enter_reverse_mode             CUR Strings[39]
#define enter_standout_mode            CUR Strings[40]
#define enter_underline_mode           CUR Strings[41]
#define erase_chars                    CUR Strings[42]
#define exit_alt_charset_mode          CUR Strings[43]
#define exit_attribute_mode            CUR Strings[44]
#define exit_ca_mode                   CUR Strings[45]
#define exit_delete_mode               CUR Strings[46]
#define exit_insert_mode               CUR Strings[47]
#define exit_standout_mode             CUR Strings[48]
#define exit_underline_mode            CUR Strings[49]
#define flash_screen                   CUR Strings[50]
#define form_feed                      CUR Strings[51]
#define from_status_line               CUR Strings[52]
#define init_string                    CUR Strings[53]
#define init_1string                   CUR Strings[54]
#define init_2string                   CUR Strings[55]
#define init_3string                   CUR Strings[56]
#define init_file                      CUR Strings[57]
#define insert_character               CUR Strings[58]
#define insert_line                    CUR Strings[59]
#define insert_padding                 CUR Strings[60]
#define key_backspace                  CUR Strings[61]
#define key_clear                      CUR Strings[62]
#define key_ctab                       CUR Strings[63]
#define key_command                    CUR Strings[64]
#define key_command_pane               CUR Strings[65]
#define key_dc                         CUR Strings[66]
#define key_dl                         CUR Strings[67]
#define key_do                         CUR Strings[68]
#define key_down                       CUR Strings[69]
#define key_eic                        CUR Strings[70]
#define key_end                        CUR Strings[71]
#define key_eol                        CUR Strings[72]
#define key_eos                        CUR Strings[73]
#define key_f0                         CUR Strings[74]
#define key_f1                         CUR Strings[75]
#define key_f10                        CUR Strings[76]
#define key_f11                        CUR Strings[77]
#define key_f12                        CUR Strings[78]
#define key_f2                         CUR Strings[79]
#define key_f3                         CUR Strings[80]
#define key_f4                         CUR Strings[81]
#define key_f5                         CUR Strings[82]
#define key_f6                         CUR Strings[83]
#define key_f7                         CUR Strings[84]
#define key_f8                         CUR Strings[85]
#define key_f9                         CUR Strings[86]
#define key_help                       CUR Strings[87]
#define key_home                       CUR Strings[88]
#define key_ic                         CUR Strings[89]
#define key_il                         CUR Strings[90]
#define key_left                       CUR Strings[91]
#define key_ll                         CUR Strings[92]
#define key_next_pane                  CUR Strings[93]
#define key_npage                      CUR Strings[94]
#define key_ppage                      CUR Strings[95]
#define key_prev_cmd                   CUR Strings[96]
#define key_quit                       CUR Strings[97]
#define key_right                      CUR Strings[98]
#define key_scroll_left                CUR Strings[99]
#define key_scroll_right               CUR Strings[100]
#define key_select                     CUR Strings[101]
#define key_sf                         CUR Strings[102]
#define key_sr                         CUR Strings[103]
#define key_stab                       CUR Strings[104]
#define key_tab                        CUR Strings[105]
#define key_up                         CUR Strings[106]
#define keypad_local                   CUR Strings[107]
#define keypad_xmit                    CUR Strings[108]
#define lab_f0                         CUR Strings[109]
#define lab_f1                         CUR Strings[110]
#define lab_f10                        CUR Strings[111]
#define lab_f11                        CUR Strings[112]
#define lab_f12                        CUR Strings[113]
#define lab_f2                         CUR Strings[114]
#define lab_f3                         CUR Strings[115]
#define lab_f4                         CUR Strings[116]
#define lab_f5                         CUR Strings[117]
#define lab_f6                         CUR Strings[118]
#define lab_f7                         CUR Strings[119]
#define lab_f8                         CUR Strings[120]
#define lab_f9                         CUR Strings[121]
#define meta_off                       CUR Strings[122]
#define meta_on                        CUR Strings[123]
#define newline                        CUR Strings[124]
#define pad_char                       CUR Strings[125]
#define parm_dch                       CUR Strings[126]
#define parm_delete_line               CUR Strings[127]
#define parm_down_cursor               CUR Strings[128]
#define parm_ich                       CUR Strings[129]
#define parm_index                     CUR Strings[130]
#define parm_insert_line               CUR Strings[131]
#define parm_left_cursor               CUR Strings[132]
#define parm_right_cursor              CUR Strings[133]
#define parm_rindex                    CUR Strings[134]
#define parm_up_cursor                 CUR Strings[135]
#define pkey_key                       CUR Strings[136]
#define pkey_local                     CUR Strings[137]
#define pkey_xmit                      CUR Strings[138]
#define print_screen                   CUR Strings[139]
#define prtr_off                       CUR Strings[140]
#define prtr_on                        CUR Strings[141]
#define repeat_char                    CUR Strings[142]
#define reset_string                   CUR Strings[143]
#define reset_1string                  CUR Strings[144]
#define reset_2string                  CUR Strings[145]
#define reset_3string                  CUR Strings[146]
#define reset_file                     CUR Strings[147]
#define restore_cursor                 CUR Strings[148]
#define row_address                    CUR Strings[149]
#define save_cursor                    CUR Strings[150]
#define scroll_forward                 CUR Strings[151]
#define scroll_reverse                 CUR Strings[152]
#define set_attributes                 CUR Strings[153]
#define set_tab                        CUR Strings[154]
#define set_window                     CUR Strings[155]
#define tab                            CUR Strings[156]
#define to_status_line                 CUR Strings[157]
#define underline_char                 CUR Strings[158]
#define up_half_line                   CUR Strings[159]
#define init_prog                      CUR Strings[160]
#define key_a1                         CUR Strings[161]
#define key_a3                         CUR Strings[162]
#define key_b2                         CUR Strings[163]
#define key_c1                         CUR Strings[164]
#define key_c3                         CUR Strings[165]
#define prtr_non                       CUR Strings[166]


struct term
{
   char	 *term_names;	/* offset in str_table of terminal names */
   char	 *str_table;	/* pointer to string table */
   short Filedes;	/* file description being written to */
   SGTTY Ottyb,		/* original state of the terminal */
	 Nttyb;		/* current state of the terminal */

   char		 Booleans[20];
   short	 Numbers[8];
   char		 *Strings[167];
};

extern struct term	_first_term;
extern struct term	*cur_term;

#define BOOLCOUNT 20
#define NUMCOUNT  8
#define STRCOUNT  167
