/**
 ** Routine that deals with sending authorization info to remote host.
 **
 ** $Id: xmitauth.c,v 1.3 1993/05/04 23:39:06 alden Exp $
 **
 ** $Log: xmitauth.c,v $
 ** Revision 1.3  1993/05/04  23:39:06  alden
 ** Cleaned up tabs
 **
 ** Revision 1.2  1993/04/17  22:28:57  root
 ** Changed log() messages to include filename
 **
 ** Revision 1.1  1993/03/30  13:19:50  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern char *converse();
extern void fail();
extern void log();

#ifndef PASSFILE
#define PASSFILE "<none-specified>"
#endif

void
  xmitauth(host)
char *host;
{
  static char *fname = "xmitauth: ";
  char *remote, *user, *pass;
  char *line, *reply;
  int resp;
  int sys_fd;
  FileBuf *sys_fbp;
  
  
  if ((sys_fd = open(PASSFILE, O_RDONLY)) == FAIL)
    fail(fname, "%s%s: %s not found", Host.name, PASSFILE);
  
  sys_fbp = fb_fdopen(sys_fd);
  
  while((line = fb_readline(sys_fbp, NULL)) != NULL)
    if (*line != '#') {
      
      remote = line;
      
      if ((line = strchr(remote, ' ')) == NULL)
	log(LOG_NOTICE, fname, "%s%s: malformed entry in %s\n",
	    Host.name, PASSFILE);
      else {
	*line++ = '\0';
	user = line;
	if ((line = strchr(user, ' ')) == NULL)
	  log(LOG_NOTICE, fname, "%s%s: malformed entry in %s\n",
	      Host.name, PASSFILE);
	else {
	  *line++ = '\0';
	  pass = line;
	  if (strcasecmp(remote, host) == MATCH)
	    break;
	}
      }
    }
  
  if (fb_error(sys_fbp))
    log(LOG_WARNING, fname, "%s%s: error reading %s: %s\n",
	Host.name, PASSFILE, errmsg(errno));
  
  if (line == NULL)
    fail(fname, "%s%s: host %s authinfo not in nntp.sys\n", Host.name,
	 host);
  
  line = str2save("authinfo user ", user);
  reply = converse(line, &resp);
  FREE(line);
  
  if (resp != NEED_AUTHDATA)
    if (resp == FAIL)
      fail(fname,
	   "%s%s: sent authinfo user, exiting due to bad response\n",
	   Host.name);
    else
      fail(fname,
	   "%s%s: sent authinfo user, exiting due to bad response: %s\n",
	   Host.name, reply);
  
  line = str2save("authinfo pass ", pass);
  reply = converse(line, &resp);
  FREE(line);
  
  if (resp != OK_AUTH)
    if (resp == FAIL)
      fail(fname,
	   "%s%s: sent authinfo pass, exiting due to bad response\n",
	   Host.name);
    else
      fail(fname,
	   "%s%s: sent authinfo pass, exiting due to bad response: %s\n",
	   Host.name, reply);
  
  CLOSE(sys_fd);
  fb_close(sys_fbp);
  return;
}
