/**
 ** Routine that deals with signal interrupts.
 **
 ** $Id: sig.c,v 1.3 1993/05/28 12:54:05 alden Exp $
 **
 ** $Log: sig.c,v $
 ** Revision 1.3  1993/05/28  12:54:05  alden
 ** Changed "#ifdef HAVE_BROKEN_SIGNAL" to "#ifndef HAVE_WORKING_SIGNAL"
 **
 ** Revision 1.2  1993/05/04  23:38:49  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:38  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

#include <signal.h>

extern Boolean Debug;
extern int Input_from;
extern Boolean One_shot;

extern Boolean Reset_log;

Boolean Abort_signaled = FALSE;
Boolean Reset_signaled = FALSE;

extern void fail();
extern void log();

void
  sighandler(sig)
int sig;
{
  static char *fname = "sighandler: ";
  
#ifndef HAVE_WORKING_SIGNAL
  signal(sig, SIG_IGN);
  signal(sig, sighandler);
#endif
  
  dlog(LOG_DEBUG, fname, "%s%s: received signal %d\n", Host.name, sig);
  
  switch(sig) {
  case SIGINT:
  case SIGTERM:
    Abort_signaled = TRUE;
    break;
    
  case SIGHUP:
    if ((Input_from & FLG_LOGFILE) && !One_shot)
      Reset_signaled = TRUE;
    else
      Abort_signaled = TRUE;
    
#ifndef HAVE_SYSLOG_H
  case SIGUSR1:
    Reset_log = TRUE;
#endif
    
    break;
    
  case SIGPIPE:
#ifdef SIGURG
  case SIGURG:
#endif
    log(LOG_DEBUG, fname, "%s%s: received signal %d - continuing\n",
	Host.name, sig);
    break;
    
  default:
    fail(fname, "%s%s: Received unknown signal %d\n", Host.name, sig);
    /*NOTREACHED*/
  }
  return;
}
