/**
 ** Routine that sends the news article to the remote host.
 **
 ** $Id: sendnews.c,v 1.6 1993/05/05 18:41:35 root Exp $
 **
 ** $Log: sendnews.c,v $
 ** Revision 1.6  1993/05/05  18:41:35  root
 ** Only rename() bfile.tmp if you are Queue_backlog'ing
 **
 ** Revision 1.5  1993/05/05  14:34:38  root
 ** Changed "queueing the backlog" message
 **
 ** Revision 1.4  1993/05/04  23:38:42  alden
 ** Cleaned up tabs
 **
 ** Revision 1.3  1993/04/20  00:34:12  alden
 ** Modified close_connection() call
 ** Changed behavior so if read_reply() fails to read a reply, then the article
 **     isn't considered a "failure", instead it is resent
 **
 ** Revision 1.2  1993/04/17  23:05:21  alden
 ** Fixed problem with read_reply timeout
 **
 ** Revision 1.1  1993/03/30  13:19:32  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern Boolean Abort_signaled;
extern int Close_after;
extern Boolean Debug;
extern long Failure_naptime;
extern int Log_after;
extern Boolean One_shot;
extern Boolean Open_art_first;
extern Boolean Queue_backlog;
extern FILE *Queue_fp;
extern Boolean Reset_signaled;
extern long Success_time;

extern void abort_nntplink();
extern void close_article();
extern Boolean get_next_art();
extern void close_connection();
extern void log();
extern void log_stats();
extern Boolean open_article();
extern Boolean open_connection();
extern char *read_reply();
extern Boolean send_connection();
extern char *send_ihave_msg();
extern void update_batchfile();

extern char *E_rename;

Boolean
  send_news()
{
  static char *fname = "send_news: ";
  Boolean failure = FALSE;
  int code;
  char *reply;
  
  while(!Abort_signaled &&
	!Reset_signaled &&
	!failure &&
	get_next_art()) {
    
    if (Open_art_first && !open_article())
      close_article();
    else {
      if (!Host.connected)
	if (!open_connection(Host.name, Host.transport))
	  return FALSE;
      /**
       ** Now that we're ready to offer an article, we want to check to see if
       ** we've been Queue_backlog'ing, if so, then we want to close that file
       ** and rename it.
       **/
      if (Queue_fp) {
	dlog(LOG_DEBUG, fname, "%sEnd queueing the backlog\n");
	FCLOSE(Queue_fp);
	if (Queue_backlog && (rename(Batchfile.tmp, Batchfile.nname) == FAIL))
	  fail(fname, E_rename, Host.name, Batchfile.tmp, Batchfile.nname,
	       errmsg(errno));
      }
      reply = send_ihave_msg(&code);
      switch(code) {
      case CONT_XFER:
	if (!send_connection(Article.fbp)) {
	  log(LOG_NOTICE, fname, "%s%s: xfer %s: %s\n", Host.name,
	      Article.filename, errmsg(errno));
	  failure = TRUE;
	  close_connection(DONT_SEND_QUIT_MSG, failure);
	} else {
	  if ((reply = read_reply(&code)) != NULL) {
	    if (Article.err != NULL)
	      free(Article.err);
	    Article.err = strsave(reply);
	    
	  }
	  
	  /**
	   ** If the response code was "FAIL", then there was a
	   ** "local" or network problem, and we don't know if
	   ** the article made it or not.  Therefore, we want to
	   ** attempt to resend this article.
	   **/
	  if (code == FAIL) {
	    failure = TRUE;
	    close_connection(DONT_SEND_QUIT_MSG, FALSE);
	  } else if ((code != OK_XFERED) && (code != ERR_XFERRJCT)) {
	    Article.count++;
	    failure = TRUE;
	    close_connection(SEND_QUIT_MSG, FALSE);
	  }
	}
	break;
	
      case ERR_NOFILE:
	(void) read_reply(&code);
	if (code == FAIL)
	  close_connection(DONT_SEND_QUIT_MSG, FALSE);
	else if ((code != OK_XFERED) && (code != ERR_XFERRJCT) &&
		 (code != ERR_XFERFAIL))
	  log(LOG_NOTICE, fname, "%s%s: bad reply: %s\n",
	      Host.name, errmsg(errno));
	break;
	
      case ERR_UNKNOWN:
      case ERR_NOFILE_CONT:
      case ERR_NOMSGID:
      case ERR_GOTIT:
	break;
	
      case ERR_COMMAND:
	failure = TRUE;
	close_connection(SEND_QUIT_MSG, FALSE);
	break;
	
      case ERR_GOODBYE:
      case FAIL:
	failure = TRUE;
	close_connection(DONT_SEND_QUIT_MSG, FALSE);
	break;
	
      default:
	log(LOG_NOTICE, fname, "%s%s: sent IHAVE %s, received: %s\n",
	    Host.name, Article.mesgid, reply);
	failure = TRUE;
      }
      
      if (!failure) {
	close_article();
	Failure_naptime = NAPTIME;
	Success_time = time(NULL);
      } else
	break;
    }
    
    if ((Stats.since_close >= Close_after) && Host.connected)
      close_connection(SEND_QUIT_MSG, FALSE);
    
    if (Stats.offered >= Log_after)
      log_stats();
  }
  
  if (Abort_signaled)
    abort_nntplink();
  
  if (Reset_signaled)
    update_batchfile();
  
  return !failure;
}
