/**
 ** Routine that deals with parsing the entry line.
 **
 ** $Id: entry.c,v 1.4 1993/05/17 15:04:13 root Exp $
 **
 ** $Log: entry.c,v $
 ** Revision 1.4  1993/05/17  15:04:13  root
 ** Modified parse_entry() to include type of entry
 **
 ** Revision 1.3  1993/05/04  23:38:11  alden
 ** Cleaned up tabs
 **
 ** Revision 1.2  1993/04/28  19:42:23  alden
 ** Added INN "logfile" mode
 **
 ** Revision 1.1  1993/03/30  13:19:17  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

extern long Delay;

extern int Xreplic;

Boolean
  parse_entry(entry, entry_type)
char *entry;
int entry_type;
{
  char *tentry, *tsysname;
  char *beg_mesgid, *end_mesgid;
  time_t sl;
#if !defined(LOOKUP_ARTICLE) || defined(INN)
  char *beg_filename, *end_filename;
#endif
#ifdef BNEWS
  char *sentto = "sent to";
#endif

  if ((entry_type == Batchfile_entry) || (entry_type == Stdin_entry)) {
    
    Article.filename = entry;
    
#ifdef BNEWS
    for (; *entry != '\0' && *entry != '\t'; entry++)
      ;
#else
    for (; *entry != '\0' && *entry != ' '; entry++)
      ;
#endif
    
    if (*entry != '\0') {
      
      *entry++ = '\0';
      Article.mesgid = entry;
      
      
      if (!Xreplic) {
	
	for (; *entry != '\0' && *entry != ' ' && *entry != '\t';
	     entry++)
	  ;
	
	if (Article.mesgid[0] != '<' ||
	    *(entry-1) != '>')
	  return FALSE;
	
	if (*entry != '\0') {
	  for (; *entry >='0' && *entry <='9'; entry++)
	    ;
	  *entry++ = '\0';
	  Article.timeid = atol(entry);
	  sl = Article.timeid + Delay - time(NULL);
	  if (sl > 1) sleep(sl);
	}
      }
    }
    
    if (Article.filename[0] == '/' && Article.filename[1] == '\0')
      Article.filename = NULL;
    
  } else {		/* entry_type == Logfile_entry */
    
#ifdef INN
    /* INN batchfile "log" format is "filename <ID> site1 site2 ..." */
    
    beg_filename = entry;	/* article file name */
    
    for (; *entry != '\0' && *entry != ' '; entry++)
      ;
    
    if (*entry == '\0')
      return FALSE;
    
    end_filename = entry;
    
    if (*++entry != '<')	/* <messageID> */
      return FALSE;
    
    beg_mesgid = entry;
    
    for (; *entry != '\0' && *entry != '>'; entry++)
      ;
    
    if (*entry == '\0')
      return FALSE;
    
    if (*(end_mesgid = ++entry) == '\0')
      return FALSE;
    
#else /* INN */
    
    for (; *entry != '\0' && *entry != '<'; entry++)
      ;
    
    if (*entry == '\0')
      return FALSE;
    
#ifndef BNEWS
    if (*(entry - 2) == '-')
      return FALSE;
#endif
    
    beg_mesgid = entry;
    
    for (; *entry != '\0' && *entry != '>'; entry++)
      ;
    
    if (*entry == '\0')
      return FALSE;
    
    if (*(end_mesgid = ++entry) == '\0')
      return FALSE;
    
#ifndef LOOKUP_ARTICLE
    if ((*(++entry) != '(') || (*(++entry) == '\0'))
      return FALSE;
    
    beg_filename = entry;
    
    for (; *entry != '\0' && *entry != ')'; entry++)
      ;
    
    if (*entry == '\0')
      return FALSE;
    
    end_filename = entry;
    
    if (*++entry == '\0')
      return FALSE;
    
#endif /* !LOOKUP_ARTICLE */
    
#ifdef BNEWS
    if (*++entry == '\0')
      return FALSE;
    
    for (; *sentto != '\0' && *sentto == *entry; entry++, sentto++)
      ;
    
    if (*sentto != '\0')
      return FALSE;
    
#endif /* BNEWS */
#endif /* INN */
    
    while (*entry != '\0' && *++entry != '\0') {
      
      for (tentry = entry, tsysname = Host.sysname;
	   *tsysname != '\0' && *tentry == *tsysname;
	   tentry++, tsysname++)
	;
      
#ifdef BNEWS
      if ((*tsysname == '\0') &&
	  ((*tentry == ',') || (*tentry == '\0'))) {
#else
	if ((*tsysname == '\0') &&
	    ((*tentry == ' ') || (*tentry == '\0'))) {
#endif
#ifndef LOOKUP_ARTICLE
	  Article.filename = beg_filename;
	  *end_filename = '\0';
#endif
	  Article.mesgid = beg_mesgid;
	  *end_mesgid = '\0';
	  return TRUE;
	}
	
	for (; *entry != '\0' && *entry != ' '; entry++)
	  ;
      }
      return FALSE;
    }
    return TRUE;
  }
