/**
 ** Main configuration file for NNTPlink.  Edit appropriately.
 **
 ** $Id: dist_conf.h,v 1.6 1993/05/04 17:43:27 alden Exp $
 **
 ** $Log: dist_conf.h,v $
 ** Revision 1.6  1993/05/04  17:43:27  alden
 ** Rearranged the layout -- cleaned it up some.
 **
 ** Revision 1.5  1993/04/28  23:34:47  root
 ** Added "INN" and "CNEWS" #define's
 ** Cleaned up comments
 **
 ** Revision 1.4  1993/04/28  18:09:34  alden
 ** Added comment about STATS_LOGLEVEL
 **
 ** Revision 1.3  1993/04/19  14:51:29  alden
 ** Added note about CLEAR_BATCHFILE needing to be an integer
 **
 ** Revision 1.2  1993/04/17  22:50:43  alden
 ** Fixed headers
 ** Fixed MAX_NAPTIME
 ** Added directory includes
 **
 ** Revision 1.1  1993/03/28  19:37:18  alden
 ** Initial revision
 **
 **
 **/
#include "preconf.h"


/**
 ** Define one and only one of the following:
 **/
#undef BNEWS
#define INN
#undef CNEWS


/**
 ** Default news batch directory.  (Can be overridden with "-B batchdir").
 **/
#define BATCHDIR	"/usr/spool/news/out.going"


/**
 ** Where should nntplink get it articles from by default?
 ** FLG_BATCHFILE or FLG_LOGFILE or FLG_STDIN
 ** (Can be overridden with "-i [batchfile|logfile|stdin]").
 **/
#define DEF_INPUT_FROM	FLG_STDIN


/**
 ** If you don't have support for syslog, but want a facsimile,
 ** define FAKESYSLOG to be the name of a file to which to log stuff.  e.g.,
 **
 **      #define FAKESYSLOG      "/usr/lib/news/nntplink.log"
 **/
#undef  FAKESYSLOG	"/usr/lib/news/nntplink.log"


/**
 ** Default news history file.  (Can be overridden with "-H historyfile").
 **/
#define HISTORYFILE	"/usr/lib/news/history"


/**
 ** Define to be the default transport protocol, either T_DECNET, T_IP_TCP,
 ** or T_DKHOST
 **/
#define HOST_TRANSPORT T_IP_TCP


/**
 ** Default news logfile.  (Can be overridden with "-F logfile").
 **/
#define LOGFILE		"/usr/lib/news/log"


/**
 ** If you are using the proposed NNTP Version 2 authentication protocol,
 ** then you must define the file where the nntp site/userid/passwords are
 ** kept.  Protect this file (mode: 600)
 **/
#define	PASSFILE	"/usr/lib/news/nntp_sys"


/**
 ** Default news spool directory.  (Can be overridden with "-S spooldir").
 **/
#define SPOOLDIR	"/usr/spool/news"


/**
 ** What level do you wish nntplink to use when syslog()'ing the statistics?
 **
 ** NOTE: For INN, you may want to use LOG_NOTICE.  Normally INN logs
 **       "interesting" events at the LOG_NOTICE level, and innlog.awk
 **       is capable of summarizing nntplink statistics if nntplink uses
 **       LOG_NOTICE.
 **/
#define STATS_LOGLEVEL	LOG_INFO



/***************************************************************************
 ** The following options are (hopefully) acceptable for your system, if you
 ** are unsure about them, do not worry.  :-)
 ***************************************************************************/

 
/**
 ** How many seconds should nntplink sleep between checks for a new batchfile?
 ** (Can be overridden with "-n num").
 **/
#define BATCHFILE_NAPTIME	60


/**
 ** Number of articles we must have offered to remote end before nntplink
 ** resets the batchfile.  This can be overridden with "-c num".
 ** NOTE:   This must be a multiple of LOG_AFTER.
 **
 ** ANOTHER NOTE:  This needs to be an interger, not a product (i.e., don't
 **                make it 1*LOG_AFTER or such).  This is due to the way
 **                the manual page is generated -- it needs an integer for
 **                this variable.
 **/
#define CLEAR_BATCHFILE	100


/**
 ** If we've offered this many articles then we want to close and reopen the
 ** link to give the remote host a chance to log statistics.  (Can be
 ** overridden with "-a num").
 **/
#define CLOSE_AFTER	100


/**
 ** After this many seconds of idle time we will close the connection.
 ** Can be overridden by "-C num" -- use "-C -1" to never close the
 ** connection.
 **/
#define CLOSE_TIMEOUT 601


/**
 ** How many seconds should nntplink sleep between checks for a new entry
 ** in either the log file or the batchfile?  (Can be overridden with
 ** "-E num").  Note:  I use 600 since I use select() to wake me up if
 ** there is something waiting on <stdin>.
 **/
#define ENTRY_SLEEP	600


/**
 ** After this many seconds of idle time we will exit from nntplink.
 ** (NOTE: Use NEVER to never exit nntplink).  Can be overridden by
 ** "-e num".
 **/
#define EXIT_TIMEOUT	NEVER


/**
 ** If we've gone FAIL_MINUTES between successful article transmissions then
 ** we'll syslog() an error message.  Can be overridden with "-m num".
 **
 ** Once we've hit FAIL_MINUTES, we will repeat the message every
 ** REPEAT_MINUTES until the error condition goes away.  Can be overridden
 ** with "-R num".
 **/
#define FAIL_MINUTES	720				/** 12 hours **/
#define REPEAT_MINUTES	720				/** 12 hours **/


/**
 ** Number of articles we must have offered to remote end before nntplink
 ** decides to log local statistics.  (Can be overridden with "-l num").
 **/
#define LOG_AFTER	100


/**
 ** How many seconds should nntplink sleep between checks for a new logfile?
 ** (Can be overridden with "-N num").
 **/
#define LOGFILE_NAPTIME	60


/**
 ** If you are going to be using the "logfile input mode" of nntplink
 ** with bnews or C news, and you haven't installed the modifications
 ** to [relaynews|inews] (which saves the path of each article to the
 ** logfile) then you must define this (it causes nntplink to do a
 ** history lookup to get the path).  You must also pick one of the
 ** dbm's -- it is used in the history lookup.
 **/
#undef LOOKUP_ARTICLE
#ifdef LOOKUP_ARTICLE
#define DBZ
#undef DBM
#undef NDBM
#endif


/**
 ** How many times can an article fail to be transferred before we either
 ** junk it or put it into the failure file?
 **/
#define MAX_ART_FAILS	2


/**
 ** When we get an error from the remote host we want to sleep for NAPTIME
 ** seconds, if we continue to get an error then we want to have exponential
 ** backoff until we get to MAX_NAPTIME seconds.
 **/
#define NAPTIME		15		/** 15 seconds **/
#define MAX_NAPTIME	(15*64)		/** 16 minutes **/


/**
 ** If we have gone this many minutes between successfull transmissions of
 ** articles then we want to "catch up" by reading to the end of the current
 ** input file (either the "logfile" or "stdin").
 **/
#define SPOOL_MINUTES	60


/**
 ** End of Configuration Section.
 **/

#include <postconf.h>
