#!/usr/local/bin/perl
eval "exec /usr/local/bin/perl -S $0 $*"
    if $running_under_some_shell;

#
# This program reads an nntplink datafile and formats the
# results into a human readable form.
#
# Author: Stephen J. Roznowski (sjr@afterlife.ncsc.mil)
#
# $Id: linkinfo.pl,v 1.1 1993/03/28 21:42:54 alden Exp $
#

# /*
#  * Format of the datafile for nntplink:
#  *
#  *  Line  Description
#  *  --------------------------------------------------------------------------
#  *   1    Pid of current nntplink (or -999 if none)
#  *   2    Version of the datafile (3.0 currently)
#  *   3    Inode of the current batchfile
#  *   4    Offset into the current batchfile
#  *   5    Inode of the current logfile
#  *   6    Offset into the current logfile
#  *   7    Last time we had a successful transmission of an article
#  *   8    Last time we reported a failure
#  */

require "ctime.pl";

$now = time();

foreach $file (@ARGV)
  {
    open(LINKFILE, $file) || printf "Unable to open $file\n";
    read(LINKFILE, $info, 1024);
    close(LINKFILE);
    ($pid,$version,$binode,$boffset,$linode,$loffset,$lastsucc,$lastfail) =
      split(' ', $info, 9999);
    printf "\nInformation for %s\n\n", $file;
    if ($pid == -999)
      {
        printf "     Nntplink pid: Not Running\n";
      }
    else
      {
        printf "     Nntplink pid: %d\n", $pid;
      }
    printf " Datafile version: %3.1f\n", $version;
    if ($binode != 0)
      {
        printf "  Batchfile inode: %d\n", $binode;
        printf " Batchfile offset: %d\n", $boffset;
      }
    if ($linode != 0)
      {
        printf "    Logfile inode: %d\n", $linode;
        printf "   Logfile offset: %d\n", $loffset;
      }
    if ($lastsucc != 0)
      {
# get first 24 chars of ctime string
        ($s = &ctime($lastsucc)) =~ tr/\012//d;
        printf "Last transmission: %s", $s;
	$diff = $now - $lastsucc;
	&Diff;
      }
    if ($lastfail != 0)
      {
        ($s = &ctime($lastfail)) =~ tr/\012//d;
        printf "     Last failure: %s", $s;
	$diff = $now - $lastfail;
	&Diff;
      }
  }

sub Diff
  {
    #    60 seconds in a minute
    #  3600 seconds in an hour
    # 86400 seconds in a day

    local($sec, $min, $hr, $day);
    $day = int( $diff / 86400 );
    $diff = $diff - $day * 86400;
    $hr = int( $diff / 3600 );
    $diff = $diff - $hr * 3600;
    $min = int( $diff / 60 );
    $sec = $diff - $min * 60;
    print " (";
    if ($day == 1) { printf " %d day", $day; }
    if ($day > 1) { printf " %d days", $day; }
    if ($hr)  { printf " %2.2d hours", $hr; }
    if ($min) { printf " %2.2d min", $min; }
    if ($sec) { printf " %2.2d sec", $sec; }
    print ")\n";
  }
