.\" BEGINPART C
.SH CATCH UP
If you have not read news for some time, there are probably more news
than you can cope with.  Using the option \-\fBa0\fP \fInn\fP will put
you into \fBcatch-up mode\fP.
.LP
The first question you will get is whether to catch up interactively
or automatically.  If you instruct \fInn\fP to catch up automatically,
it will simply mark all articles in all groups as read, thus bringing
you \fIcompletely up-to-date\fP.
.LP
If you choose the interactive mode, \fInn\fP will locate all groups
with unread articles, and for each group it will prompt you for an
action to take on the group.  An action is selected using a single
letter followed by \fBreturn\fP.  The following actions are available:
.TP
.B y
Mark all articles as read in current group.
.TP
.B n
Do not update group (this is the default action if you just hit
\fBreturn\fP).
.TP
.B r
Enter reading mode to read the group.
.TP
.B U
Unsubscribe to the group.
.TP
.B ?
Give a list of actions.
.TP
.B q
Quit.
When you quit, \fInn\fP will ask whether the
rest of the groups should be updated unconditionally or whether they
should remain unread.
.SH VARIABLES AND OPTIONS
It is possible to control the behaviour of \fInn\fP through the
setting (and unsetting) of the variables described below.  There are
several ways of setting variables:
.br
\- Through command line options when \fInn\fP is invoked.
.br
\- Through global \fBset\fP commands in the init file.
.br
\- Through \fBset\fP or \fBlocal\fP commands executed from entry macros.
.br
\- Through the \fB:set\fP extended command when you run \fInn\fP.
.LP
There are four types of variables:
.br
\- Boolean variables
.br
\- Integer variables
.br
\- String variables
.br
\- Key variables
.LP
Boolean variables control a specific function in \fInn\fP, e.g.
whether the current time is shown in the prompt line.  A boolean
variable is set to
.B true
with the command
.br
	\fBset\fP \fIvariable\fP
.br
and it is set to
.B false
with either of the following (equivalent) commands:
.br
	\fBunset\fP \fIvariable\fP
.br
	\fBset no\fP\fIvariable\fP
.LP
You can also toggle the value of a boolean variable using the command:
.br
	\fBtoggle\fP \fIvariable\fP
.LP
For example:
.br
	\fBset\fP time
.br
	\fBunset\fP time
.br
	\fBset\fP notime
.br
	\fBtoggle\fP time
.LP
Integer variables control an amount e.g. the size of the preview
window, or the maximum number of articles to read in each group.  They
are set with the following command:
.br
	\fBset\fP \fIvariable value\fP
.br
In some cases, not setting an integer value has a special meaning,
for example, not having a minimal preview window or reading all
articles in the groups no matter how many there are.  The special
meaning can be re-established by the following command:
.br
	\fBunset\fP \fIvariable\fP
.br
For example:
.br
	\fBset\fP window 7
.br
	\fBunset\fP limit
.br
.LP
String variables may specify directory names, default values for
prompts, etc.  They are set using the command
.br
	\fBset\fP \fIvariable string\fP
.br
Except for file and directory names, the
.I string
value starts at the first non-blank character after the variable name
and continues to the end of the line \fIincluding all trailing
blanks on the line\fP!
.LP
Key variables control the keys used to control special functions
during user input such as line editing and completion.  They are set
using the command
.br
	\fBset\fP \fIvariable key-name\fP
.br
.LP
The current variable settings can be shown with the
.B :set
command without arguments.
.LP
Variables are global by default, but a local instantiation of the
variable can be created using the \fB:local\fP command.  The local
variable will overlay the global variable as long as the current group
is active, i.e. the global variable will be used again when you exit
the current group.  The initial value of the local variable will be
the same as the global variable, unless a new value is specified in
the \fB:local\fP command:
.sp 0.5v
	\fB:local\fP \fIvariable\fP [ \fIvalue\fP ]
.sp 0.5v
.LP
The following variables are available:
.TP
\fBalso-subgroups\fP	(boolean, default true)
When set, a group name in the presentation sequence will also cause
all the subgroups of the group to be included, for example, comp.unix
will also include comp.unix.questions, etc.  When \fBalso-subgroups\fP
is not set, subgroups are only included if the group name is followed
by a `.' in which case the main group is \fInot\fP included, i.e.
`comp.unix' is not included when `comp.unix.' is specified in the
presentation sequence, and vice-versa.  Following a group name by an
asterisk `*', e.g. comp.unix*, will include the group as well as all
subgroups independently of the setting of \fBalso-subgroups\fP.
.TP
\fBappend-signature-mail\fP	(boolean, default false)
When false, it is assumed that the .signature file is automatically
appended to responses sent via E-mail.  If true, .signature will be
appended to the letter (see query-signature).
.TP
\fBappend-signature-post\fP	(boolean, default false)
When false, it is assumed that the .signature file is automatically
appended to posted articles.  If true, .signature will explicitly be
appended to posted articles (see query-signature).
.TP
\fBattributes\fP \fIsymbols\fP	(string, default ....)
Each element in this string represents a symbol used to represent an
article attribute when displayed on the screen.  See the section on
Marking Articles and Attributes.
.TP
\fBauto-junk-seen\fI	(boolean, default true)
When set, articles which have the \fIseen attribute\fP (,) will be marked
read when the current group is left.  If not set, these articles will
still be either unread or marked seen the next time the group is
entered (see also \fBconfirm-junk-seen\fP and \fBretain-seen-status\fI).
.TP
\fBauto-preview-mode\fP		(boolean, default false)
Enables \fIAuto Preview Mode\fP.  In this mode, selecting an article
on the menu using its article id (letter a-z) will enter preview mode
on that article immediately.  Furthermore, the `n' {\fBnext-article\fP}
command will preview the next article on the menu only if it has the
same subject as the current article; otherwise, it will return to the
menu with the cursor placed on the next article.  The \fBcontinue\fP
command at the end of the article and the `=' {\fBgoto-menu\fP}
returns to the menu immediately as usual.
.TP
\fBbackup\fP	(boolean, default true)
When set, a copy of the initial .newsrc and select files will save be
the first time they are changed.  \fInn\fP remembers the initial
contents of these files internally, so the backup variable can be set
any time if not set on start-up.
.TP
\fBbackup-suffix\fP \fIsuffix\fP	(string, default ".bak")
The suffix appended to file names to make the corresponding backup
file name (see \fBbackup\fP).
.TP
\fBbug-report-address\fP \fIaddress\fP	(string, default nn-bugs@dkuug.dk)
The mail address to which bug reports created with the \fB:bug\fP
command are sent.
.TP
\fBcase-fold-search\fP		(boolean, default true)
When set, string and regular expression matching will be case
independent.  This is related to all commands matching on names or
subjects, except in connection with auto-kill and auto-select where
the individual kill file entries specifies this property.
.TP
\fBcollapse-subject\fP \fIoffset\fP	(integer, default 25)
When set (non-negative), subject lines which are too long to be
presented in full on the menus will be "collapsed" by removing a
sufficient number of characters from the subject starting at the given
\fIoffset\fP in the subject.  This is useful in source groups where
the "Part (01/10)" string sometimes disappears from the menu.  When
not set (or negative), the subjects are truncated.
.TP
\fBcolumns\fP \fIcol\fP	(integer, default screen width)
This variable contains the screen width i.e. character positions per
line.
.TP
\fBcomp1-key\fP \fIkey\fP	(key, default \fBspace\fP)
The key which gives the first/next completion, and the default value
when \fInn\fP is prompting for a string, e.g. a file name.
.TP
\fBcomp2-key\fP \fIkey\fP	(key, default \fBtab\fP)
The key which ends the current completion and gives the first
completion for the next component
when \fInn\fP is prompting for a string, e.g. a file name.
.TP
\fBcompress\fP		(boolean, default false)
This variable controls whether text compression (see the
\fBcompress\fP command) is turned on or off when an article is
shown.  The compression is still toggled for the current article with
the \fBcompress\fP command key.
.TP
\fBconfirm-append\fP		(boolean, default false)
When set, \fInn\fP will ask for confirmation before appending an
article to an existing file (see also \fBconfirm-create\fP).
.TP
\fBconfirm-auto-quit\fP		(boolean, default false)
When set, \fInn\fP will ask for confirmation before quitting after
having read the last group.  If not confirmed, \fInn\fP will recycle
the presentation sequence looking for groups that were skipped with
the `N' {\fBnext-group\fP} command.  But it will not look for new
articles arrived since the invokation of \fInn\fP.
.TP
\fBconfirm-create\fP		(boolean, default true)
When set, \fInn\fP will ask for confirmation before creating a new
file or directory when saving or unpacking an article (see also
\fBconfirm-append\fP).
.TP
\fBconfirm-entry\fP		(boolean, default false)
When set, \fInn\fP will ask for confirmation before entering a group
with more than \fBconfirm-entry-limit\fP unread articles (on the first
menu level).  It is useful on slow terminals if you don't want to wait
until \fInn\fP has drawn the first menu to be able to skip the group.
  Answering no to the "Enter?" prompt will cause \fInn\fP to skip to
the next group without marking the current group as read.  If you
answer by hitting \fBinterrupt\fP, \fInn\fP will ask the question
"Mark as read?" which allows you to mark the current group as read
before going to the next group.  If this second question is also
answered by hitting \fBinterrupt\fP, \fInn\fP will quit immediately.
.TP
\fBconfirm-entry-limit\fP \fIarticles\fP	(integer, default 0)
Specifies the minimum number of unread articles in a group for which
the \fBconfirm-entry\fP functionality is activated.
.TP
\fBconfirm-junk-seen\fP		(boolean, default false)
When set, \fInn\fP will require confirmation before marking seen
articles as read when \fBauto-junk-seen\fP is set.
.TP
\fBconfirm-messages\fP		(boolean, default false)
In some cases, \fInn\fP will sleep one second (or more) when it has shown a
message to the user, e.g. in connection with macro debugging.  Setting
.B confirm-messages
will cause \fInn\fP to
\fIwait\fP for you to confirm all messages by hitting any
key.  (It will show the symbol <> to indicate that it is awaiting
confirmation.)
.TP
\fBcross-filter-seq\fP		(boolean, default true)
When set, cross posted articles will be presented in the first
possible group, i.e. according to the current presentation sequence
(\fIcross\fP-post \fIfilter\fPing on \fIseq\fPuence).  The article is
automatically marked read in the other cross posted groups unless you
unsubscribe to the first group in which it was shown before reading
the other groups.  Likewise, it is sufficient to leave the article
unread in the first group to keep it for later handling.
  If not set, cross-postings are shown in the first group occurring on
the Newsgroups: line which the user subscribes to (i.e. you let the
poster decide which group is most appropriate to read his posting).
.TP
\fBcross-post\fP		(boolean, default false)
Normally, \fInn\fP will only show cross-posted articles in the first
subscribed group on the Newsgroups: line.  When
.B cross-post
is set, \fInn\fP will show cross-posted articles in all subscribed
groups to which they are posted.
.TP
\fBdata-bits\fP \fIbits\fP	(integer, default 7)
When set to 7, \fInn\fP will display characters with the 8th bit set
using a meta-notation \fBM-\fP\fI7bit-char\fP.  If set to 8, these
characters are sent directly to the screen (unless \fBmonitor\fP is
set).
.TP
\fBdate\fP		(boolean, default true)
If set \fInn\fP will show the article posting date when articles are
read.
.TP
\fBdebug\fP \fImask\fP	(integer, default 0)
Look in the source if you are going to use this.
.TP
\fBdecode-header-file\fP \fIfile\fP	(string, default "Decode.Headers")
The name of the file in which the header and initial text of articles
decoded with the \fB:decode\fP command is saved.  Unless the file name
starts with a `/', the file will be created in the same directory as
the decoded files.  The information is not saved if this variable is
not set.
.TP
\fBdecode-skip-prefix\fP \fIN\fP	(integer, default 2)
When non-null, the \fB:decode\fP command will automatically skip
\fIupto\fP \fIN\fP characters at the beginning of each line to find
valid uuencoded data.  This allows \fInn\fP to automatically decode
(multi-part) postings which are both uuencoded and packed with shar.
.TP
\fBdefault-distribution\fP \fIdistr\fP	(string, default not set)
The distribution to use as the default suggestion when posting
articles using the \fBpost\fP command.  If it is not set, the
first component of the group name is used as the suggested
distribution, e.g. `comp' when posting to comp.whatever.
.TP
\fBdefault-save-file\fP \fIfile\fP	(string, default +$F)
The default save file used in quick save mode.  It can also be
specified using the abbreviation "+" as the file name in normal save
mode.
.TP
\fBdelay-redraw\fP		(boolean, default false)
Normally, \fInn\fP will redraw the screen after extended
commands (:cmd) that clear the screen.  When \fBdelay-redraw\fP is set
\fInn\fP will prompt for another extended command instead of redrawing
the screen (hit \fBreturn\fP to redraw).
.TP
\fBedit-patch-command\fP	(boolean, default true)
When true, the \fB:patch\fP command will show the current
\fBpatch-command\fP and give you a chance to edit it before applying
it to the articles.
.TP
\fBedit-print-command\fP	(boolean, default true)
When true, the \fBprint\fP command will show the current \fBprinter\fP
command and give you a chance to edit it before printing the articles.
Otherwise the articles are just printed using the current \fBprinter\fP
command.
.TP
\fBedit-response-check\fP	(boolean, default true)
When editing a response to an article, it normally does not have any
meaning to send the initial file prepared by \fInn\fP unaltered, since
it is either empty or only contains included material.  When this
variable is set, exiting the editor without having changed the file
will automatically abort the response action without confirmation.
.TP
\fBedit-unshar-command\fP	(boolean, default false)
When true, the \fB:unshar\fP command will show the current
\fBunshar-command\fP and give you a chance to edit it before applying
it to the articles.
.TP
\fBeditor\fP \fIcommand\fP	(string, default not set)
When set, it will override the current EDITOR environment variable
when editing responses and new articles.
.TP
\fBentry-report-limit\fP \fIarticles\fP	(integer, default 300)
Normally, \fInn\fP will just move the cursor to the upper left corner
of the screen while it is reading articles from the database on
entry to a group.  For large groups this may take more than a fraction
of a second, and \fInn\fP can then report what it is doing.  If
it must read more articles than the number specified by this variable,
\fInn\fP will report which group and how many articles it is reading.
.TP
\fBerase-key\fP \fIkey\fP	(key, default tty erase key)
The key which erases the last input character
when \fInn\fP is prompting for a string, e.g. a file name.
.TP
\fBexpert\fP		(boolean, default false)
If set \fInn\fP will use slightly shorter prompts (e.g. not tell you
that ? will give you help), and be a bit less verbose in a few other
cases (e.g. not remind you that posted articles are not available
instantly).
.TP
\fBexpired-message-delay\fP \fIpause\fP	(integer, default 1)
If a selected article is found to have been expired, \fInn\fP will
normally give a message about this and sleep for a number of seconds
specified by this variable.  Setting this variable to zero will still
make \fInn\fP give the message without sleeping afterwards.  Setting
it to -1 will cause the message not to be shown at all.
.TP
\fBflow-control\fP	(boolean, default true)
When set, \fInn\fP will turn on xon/xoff flow-control before writing
large amounts of text to the screen.  This should guard against
lossage of output, but in some network configurations it has had the
opposite effect, losing several lines of the output.  This variable
is always true on systems with CBREAK capabilities which can do single
character reads without disabling flow control.
.TP
\fBflush-typeahead\fP	(boolean, default false)
When true, \fInn\fP will flush typeahead prior to reading commands
from the keyboard.  It will not flush typeahead while reading
parameters for a command, e.g. file names etc.
.TP
\fBfolder\fP \fIdirectory\fP	(string, default ~/News)
The full pathname of the
.I folder directory
which will replace the + in folder names.  It will be initialized from
the FOLDER environment variable if it is not set in the
.I init
file.
.TP
\fBfsort\fP		(boolean, default true)
When set, folders are sorted alphabetically according to the subject
(and age).
Otherwise, the articles in
a folder will be presented in the sequence in which they were saved.
.TP
\fBheader-lines\fP \fIlist\fP	(string, no default)
When set, it determines the list of header fields that are shown when
an article is read instead of the normal one line header showing the
author and subject.  See the full description in the section on
Customized Article Headers below.
.TP
\fBhelp-key\fP \fIkey\fP	(key, default \fB?\fP)
The key which ends the current completion and gives a list of possible
completions for the next component
when \fInn\fP is prompting for a string, e.g. a file name.
.TP
\fBinclude-art-id\fP		(boolean, default false)
The first line in a response with included material normally reads
\&"...somebody... writes:" without a reference to the specific article
from which the quotation was taken (this is found in the References:
line).  When this variable is set, the line will also include the
article id of the referenced article: "In ...article... ... writes:".
.TP
\fBinclude-full-header\fP	(boolean, default false)
When set, the \fBmail\fP (M) command will always include the full
header of the original article.  If it is not set, it only includes
the header when the article is forwarded without being edited.
.TP
\fBincluded-mark\fP \fIstring\fP	(string, default ">")
This string is prefixed to all lines in the original article that are
included in a reply or a follow-up.  (Now you have the possibility to
change it, but please don't.  Lines with a mixture of prefixes like
.br
   : orig-> <> } ] #- etc.
.br
are very difficult to comprehend.  Let's all use the standard folks!
(And hack inews if it is the 50% rule that bothers you.)
.TP
\fBkeep-unsubscribed\fP		(boolean, default true)
When set, unsubscribed groups are kept in .newsrc.  If not set,
\fInn\fP will automatically remove all unsubscribed from .newsrc if
\fBtidy-newsrc\fP is set.  See also \fBunsubscribe-mark-read\fP.
.TP
\fBkill\fP		(boolean, default true)
If set, \fInn\fP performs automatic kill and selection based on the
.I kill
file.
.TP
\fBkill-key\fP \fIkey\fP	(key, default tty kill key)
The key which deletes the current line
when \fInn\fP is prompting for a string, e.g. a file name.
.TP
\fBlayout\fP \fInumber\fP	(integer, default 1)
Set the menu layout.  The argument must be a number between 0 and 4.
.TP
\fBlimit\fP \fImax-articles\fP	(integer, default infinite)
.I Limit
the maximum number of articles presented in each group to
.I max-articles.
The default is to present
.I all
unread articles no matter how many there are.  Setting this variable,
only the most recent
.I max-articles
articles will be presented, but all the articles will still be marked
as read.  This is useful to get up-to-date quickly if you have not
read news for a longer period.
.TP
\fBlines\fP \fIlin\fP	(integer, default screen hight)
This variable contains the screen hight i.e. number of lines.
.TP
\fBlong-menu\fP		(boolean, default false)
If set \fInn\fP will not put an empty line after the header line and
an empty line before the prompt line; this gives you two extra menu
lines.
.TP
\fBmacro-debug\fP	(boolean, default false)
If set \fInn\fP will trace the execution of all macros.  Prior to the
execution of each command or operation in a macro, it will show the
name of the command or the input string or key stroke at the bottom of
the screen.
.TP
\fBmail\fP \fIfile\fP	(string, default not set)
\fIfile\fP must be a full path name of a file.  If defined, \fInn\fP will
check for arrival of new mail every minute or so by looking at the
specified file.
.TP
\fBmail-format\fP	(boolean, default false)
When set, \fInn\fP will save articles in a format that is compatible
with normal mail folders.
.TP
\fBmail-header\fP \fIheaders\fP	(string, default not set)
The \fIheaders\fP string specifies one or more extra header lines
(separated by semi-colons `;') which are added to the header of mail
sent from \fInn\fP using the \fBreply\fP and \fBmail\fP commands.  For
example:
.br
   set mail-header Reply-To: storm@texas.dk
.br
.TP
\fBmail-record\fP \fIfile\fP	(string, default not set)
\fIfile\fP must be a full path name of a file.  If defined, all replies and
mail will be saved in this file in standard
.I mailbox
format, i.e. you can use you favourite mailer (and \fInn\fP) to look at
the file.
.TP
\fBmail-script\fP \fIfile\fP	(string, default not set)
When set, \fInn\fP will use the specified file instead of the standard
\fIaux\fP script when executing the \fBreply\fP and \fBmail\fP
commands.
.TP
\fBmailer\fP \fIshell-command\fP	(string, default REC_MAIL)
The program which is invoked by \fInn\fP to deliver a message to the
mail transport.  The program will be given a complete mail message
including a header containing the recipient's address.  See also
\fBmailer-pipe-input\fP.
.TP
\fBmailer-pipe-input\fP		(boolean, default true)
When set, the message to be sent will be piped into the \fBmailer\fP
program.  Otherwise, the file containing the message will be given as
the first (and only) argument to the \fBmailer\fP command.
.TP
\fBmark-overlap\fP	(boolean, default false)
When set, \fInn\fP will draw a line (using the underline capabilities
of the terminal if possible) to indicate the end of the overlap (see the
\fBoverlap\fP variable).
.TP
\fBmin-window\fP \fIsize\fP	(integer, default 7)
When the \fBwindow\fP variable is not set, \fInn\fP will clear the
screen to preview an article if there are less than \fIsize\fP unused
lines at the bottom of the menu screen.
.TP
\fBmmdf-format\fP	(boolean, default false)
When set, \fInn\fP will save articles in MMDF format.
.TP
\fBmonitor\fP		(boolean, default false)
When set, \fInn\fP will show
.I all
characters in the received messages using a "cat -v" like format.
Otherwise, only the printable characters are shown (default).
.TP
\fBnew-group-action\fP \fIaction\fP	(integer, default 3)
This variable controls how new groups are treated by \fInn\fP.  It is
an integer variable, and the following values can be used.  Some of
these actions (marked with an *) will only work when
\fBkeep-unsubscribed\fP is set, since the presence of a group in
\&.newsrc is the only way to recongnize it as an old group:
.sp 0.5v
\fB0\fP)  Ignore groups which are not in \&.newsrc.  This will obviously
include new groups.
.sp 0.5v
\fB1\fP*)  Groups not in \&.newsrc are considered to be new, and are
inserted at the beginning of the \&.newsrc file.
.sp 0.5v
\fB2\fP*)  Groups not in \&.newsrc are considered to be new, and are
appended to the end of the \&.newsrc file.
.sp 0.5v
\fB3\fP)  New groups are recognized via a time-stamp saved in the
file \&.nn/LAST and in the database, i.e. it is not dependent on the
groups currently in \&.newsrc.  The new groups are automatically
appended to \&.newsrc with subscription.  Old groups not present in
\&.newsrc will be considered to be unsubscribed.
.sp 0.5v
\fB4\fP)  As \fB3\fP, but the user is asked to confirm that the new
group should be appended to \&.newsrc.  If rejected, the group will not
be appended to \&.newsrc, and thus be regarded as unsubscribed.
.sp 0.5v
\fB5\fP)  As \fB4\fP, except that the information is stored in a
format compatible with the \fIrn\fP news reader (\&.rnlast).  This needs
to be tested!
.TP
\fBnews-header\fP \fIheaders\fP	(string, default not set)
The \fIheaders\fP string specifies one or more extra header lines
(separated by semi-colons `;') which are added to the header of
articles posted from \fInn\fP using the \fBfollow\fP and \fBpost\fP
commands.
.TP
\fBnews-record\fP \fIfile\fP	(string, default not set)
Save file for follow-ups and postings.  Same rules and format as the
\fBmail-record\fP variable.
.TP
\fBnews-script\fP \fIfile\fP	(string, default not set)
When set, \fInn\fP will use the specified file instead of the standard
\fIaux\fP script when executing the \fBfollow\fP and \fBpost\fP
commands.
.TP
\fBnewsrc\fP \fIfile\fP		(string, default "~/.newsrc")
Specifies the file used by \fInn\fP to register which groups and
articles have been read.  The default setting corresponds to the
\&.newsrc file used by other news readers.  Notice that \fInn\fP release
6.4 \fIdoes allow\fP individual articles to be marked unread, and some
articles marked unread, and thus no longer messes up \&.newsrc for other
news readers!
.TP
\fBnntp-cache-dir\fP \fIdirectory\fP	(string, default "~/.nn")
When NNTP is used, \fInn\fP needs to store articles temporarily on
disk.  This variable specifies which directory \fInn\fP will use to
hold these files.  The default value may be changed during
configuration.  This variable can only be set in the init file.
.TP
\fBnntp-cache-size\fP \fIsize\fP	(integer, default 10, maximum 10)
Specifies the number of temporary files in the nntp cache.  The
default and maximum values may be changed during configuration.
.TP
\fBnntp-debug\fP	(boolean, default false)
When set, a trace of the nntp related traffic is displayed in the
message line on the screen.
.TP
\fBold\fP [\fImax-articles\fP]	(integer, default not set)
When
.B old
is set, \fInn\fP will present (or scan) all (or the last
\fImax-articles\fP) unread as well as
read articles.  While
.B old
is set, \fInn\fP will
.I never
mark any unread articles as read.
.TP
\fBorig-to-include-mask\fP \fIN\fP	(integer, default 3)
When replying to an article, \fInn\fP will include some of the header
lines which may be used to construct a proper mail address for the
poster of the original article.  These addresses are placed on
\fIOrig-To:\fP lines in the reply header and will automatically be
removed before the letter is sent.  This variable specifies which
headers from the article are included; its value \fIN\fP is the sum of
the following values:
.br
	1: \fIReply-To:\fP
.br
	2: \fIFrom:\fP
.br
	4: \fIPath:\fP
.TP
\fBoverlap\fP \fIlines\fP	(integer, default 2)
Specifies the number of overlapping lines from one page to the next
when paging through an article in reading mode.
The last line from the previous page
will be underlined if the terminal has that capability.
.TP
\fBpager\fP \fIshell-command\fP		(string, default $PAGER)
This is the pager used by the \fB:admin\fP command (and \fInnadmin\fP)
when it executes certain commands, e.g. grepping in the Log file.
.TP
\fBpatch-command\fP \fIshell-command\fP	(string, default "patch -p0")
This is the command which is invoked by the \fB:patch\fP command.
.TP
\fBpreview-continuation\fP \fIcond\fP	(integer, default 12)
This variable determines on what terms the following article should be
automatically shown when previewing an article, and the
\fBnext-article\fP command is used, or \fBcontinue\fP is used at the
end of the article.  The following values
can be used:
.br
\fB0\fP \- never show the next article (return to the menu).
.br
\fB1\fP \- always show the next article (use 'q' to return to the menu).
.br
\fB2\fP \- show the next article if it has the same subject as the
current article, else return to the menu.
.br
The value should be the \fIsum\fP of two values: one for the action
after using \fBcontinue\fP on the last page of the article, and one
for the action performed when the \fBnext-article\fP command is used
\fImultiplied by 10\fP.
.TP
\fBpreview-mark-read\fP		(boolean, default true)
When set, previewing an article will mark the article as read.
.TP
\fBprinter\fP \fIshell-command\fP	(string, default is system dep.)
This is the default value for the
.B print
command.  It should include an option which prevents the spooler from
echoing a job-id or similar to the terminal to avoid problems with
screen handling (e.g. lp -s on System V).
.TP
\fBquery-signature\fP		(boolean, default ...)
Will cause \fInn\fP to require confirmation before appending
the \&.signature file to out-going mail or news if the corresponding
\fBappend-sig-\fP... variable is set.
.TP
\fBquick-count\fP	(boolean, default true)
When set, calculating the total number of unread articles at start-up
is done by simple subtracting the first unread article number from the
total number of articles in each group.  This is very fast, and fairly
accurate but it may be a bit too large.  If not set, each line in
.newsrc will be interpreted to count every unread article, thus giving
a very accurate number.  This variable is also used by \fInncheck\fP.
.TP
\fBquick-save\fP	(boolean, default false)
When set, \fInn\fP will not prompt for a file name when an article is
saved (unless it belongs to a folder).
Instead it uses the save file specified for the current group in the
init file or the default save file.
.TP
\fBre-layout\fP \fIN\fP		(integer, default 0)
Normally on the menu, \fInn\fP will prefix the subject a number of
`>'s corresponding to the number of references on the References:
line.  The \fBre-layout\fP variable may be set to use a different
prefix on the subjects:
.br
.nf
	0:  One `>' per reference is shown (default).
	1:  A single `>' is shown if the Subject contains Re:.
	2:  The number of references is shown as `n>'
	3:  A single Re: is shown.
.fi
.TP
\fBrecord\fP \fIfile\fP	(string, no default)
Setting this
.I pseudo
variable will set both the \fBmail-record\fP and the
\fBnews-record\fP variables to the specified pathname.
.TP
\fBrepeat\fP		(boolean, default false)
When set, \fInn\fP will not eliminate duplicated subject lines on
menus (I cannot imagine why anyone should want that, but....)
.TP
\fBrepeat-group-query\fP	(boolean, default false)
When set, invoking \fInn\fP with the \fB\-g\fP option will always
repeat the query for a group to enter until you quit explicitly.
(Same as setting the \fB\-r\fP option permanently).
.TP
\fBresponse-check-pause\fP \fIpause\fP	(integer, default 2)
Specifies the number of seconds to wait after posting an article to
see whether the action *might* have failed.  Some commands run in the
background and may thus not have completed during this period, so even
when \fInn\fP says "Article posted", it may still fail (in which case
you are informed via mail).
.TP
\fBresponse-default-answer\fP \fIaction\fP	(string, default "send")
The default action to be taken when hitting \fBreturn\fP to the
"response action" prompt  (abort, edit, send, view, write).  If it is
unset, no default action is defined.
.TP
\fBretain-seen-status\fP	(boolean, default false)
Normally, seen articles will just be unread the next time the group is
entered (unless they were marked read by \fBauto-junk-seen\fP).  If
\fBretain-seen-status\fP is set, the seen attribute on the articles
will survive to the next time the group is entered.  (This is not
recommended because it may result in very large select files).
.TP
\fBretry-on-error\fP \fItimes\fP	(integer, default 0)
When set, \fInn\fP will try the specified number of \fItimes\fP to
open an article before reporting that the article does not exist
anymore.  This may be necessary in some network environments.
.TP
\fBsave-counter\fP \fIformat\fP	(string, default "%d")
This is the printf-format which \fInn\fP uses to create substitution
string for the trailing * in save file names.  You can set this to
more complex formats if you like, but be sure that it will produce
different strings for different numbers.  An alternative format which
seems to be popular is ".%02d" .
.TP
\fBsave-counter-offset\fP \fIN\fP	(integer, default 0)
Normally, file names created with the \fIpart.*\fP form will
substitute the \fI*\fP with successive numbers starting from one.
Setting this variable will cause these numbers to start from \fIN\fP+1.
.TP
\fBsave-report\fP	(boolean, default true)
When set, a message reporting the number of lines written is shown
after saving an article.  Since messages are shown for a few seconds,
this may slow down the saving of many articles (e.g. using the
.B S*
command).
.TP
\fBscroll-clear-page\fP		(boolean, default true)
Determines whether \fInn\fP clears the screen before showing each new
page of an article.
.TP
\fBselect-leave-next\fP		(boolean, default false)
When set, you will be asked whether to select articles with the
\fBleave-next\fP attribute on entry to a group with left over
articles.
.TP
\fBselect-on-sender\fP		(boolean, default false)
Specifies whether the \fBfind\fP (=) command in article selection mode
will match on the subject or the sender.
.TP
\fBshell\fP \fIprogram\fP	(string, default $SHELL)
The shell program used to execute shell escapes.
.TP
\fBshell-restrictions\fP	(boolean, default false)
When set (in the init file), \fInn\fP will not allow the user to
invoke the shell in any way, including saving on pipes.  It also
prevents the user from changing certain variables containing commands.
.TP
\fBsilent\fP		(boolean, default false)
When set, \fInn\fP wont print the logo or "No News" if there are no
unread articles.  Only useful to set in the init file or with the
.B \-Q
option.
.TP
\fBslow-mode\fP		(boolean, default false)
When set, \fInn\fP will cut down on the screen output to give better
response time at low speed.
Normally, \fInn\fP will use standout mode (if possible) to mark
selected articles on the menu, but when \fBslow-mode\fP is set, \fInn\fP will
just put an asterisk `*' next to the article identifier on selected
articles.  Also when \fBslow-mode\fP is set \fInn\fP will avoid
redrawing the screen in the following cases:  After a \fBgoto-group\fP
command an empty menu is shown (hit \fBspace\fP to make it appear),
and after responding to an article, only the prompt line is shown (use
^L to redraw the screen).  To avoid redrawing the screen aftern an
extended command, set the \fBdelay-redraw\fP variable as well.
.TP
\fBslow-speed\fP \fIspeed\fP	(integer, default 1200)
If the terminal is running at this baud rate or lower, the \fBon
slow\fP (see the section on init files) condition will be true, and
the \fBon fast\fP will be false (and vice-versa).
.TP
\fBsort\fP		(boolean, default true)
When set, \fInn\fP will sort articles according to the current
\fBsort-mode\fP on entry to a group.  Otherwise, articles will be
presented in order of arrival.
.TP
\fBsort-mode\fP \fImode\fP	(integer, default 1)
The default sort algorithm used to sort the articles on entry to a
news group.  It is a numeric value corresponding to one of the sorting
methods described in connection with the :sort command:
.br
	0 \- arrival (no sorting)
.br
	1 \- subject (subjects ordered after age of first article)
.br
	2 \- lexical (subjects in lexicographical order)
.br
	3 \- age (articles ordered after posting date only)
.br
	4 \- sender (articles ordered after sender's name)
.TP
\fBspell-checker\fP \fIshell-command\fP	(string, default not set)
When set, responses can be checked for spelling mistakes via the
(i)spell action.  The command to perform the spelling is given the
file containing the full article including header as its only
argument.  If the spell checker can fix spelling mistakes, it must
apply the changes directly to this file.
.TP
\fBsplit\fP		(boolean, default true)
When set, digests will automatically and silently be split into
sub-articles which are then handled transparently as normal articles.
Otherwise, digests are presented as one article (which you can split
on demand with the
.B G
command).
.TP
\fBstop\fP \fIlines\fP	(integer, default not set)
When
.B stop
is set, \fInn\fP will only show the first \fIlines\fP lines of the
of each article
before prompting you to continue.  This is useful on slow terminals and
modem lines to be able to see the first few lines of longer articles
(and skipping the rest with the
.B n
command).
.TP
\fBsubject-match-limit\fP \fIlength\fP	(integer, default 20)
If one article's subject is identical to the first part of another
article, the two subjects will still be considered identical if the
length of the shorter subject is at least the limit set by this
variable.  This is mainly used to get articles whose subject line has
been truncated for some reason (who said notefiles?) aligned with the
proper set of articles anyway.
.TP
\fBsubject-match-offset\fP \fIoffset\fP	(integer, default 0)
When set to a positive number, that many characters at the beginning
of the subject will be ignored when comparing subjects for ordering
and equality purposes.
.TP
\fBsubject-match-parts\fP	(boolean, default false)
When set, two subjects will be considered equal if they are identical
upto the first (differing) digit.  Together with the
\fBsubject-match-offset\fP variable, this can be used in source groups
where the subject often has a format like:
.sp 0.5v
	vXXXXXX: Name of the package (Part 01/04)
.sp 0.5v
Setting \fBsubject-match-offset\fP to 8 and \fBsubject-match-parts\fP
to true will make \fInn\fP consider all four parts of the package
having the same subject (and thus be selectable with `*').
.sp 0.5
Notice that changing the \fBsubject-match-\fP... variables manually
will not have an immediate effect.  To reorder the menu, an explicit
\fB:sort\fP command must be performed.  These variables are mainly
intended to be set using the \fB:local\fP command in \fBon entry\fP
macros for source and binary groups (entry macros are evaluated before
the menu is collected and sorted).
.TP
\fBsuggest-default-save\fP	(boolean, default true)
When set, \fInn\fP will present the \fBdefault-save-file\fP when
prompting for a save file name in a group without a specific save
file.  When not set, no file name is presented, and to use the default
save file, a single + must be specified.
.TP
\fBtidy-newsrc\fP		(boolean, default false)
When set, \fInn\fP will automatically remove lines from .newsrc which
represent groups not found in the active file or unsubscribed groups
if \fBkeep-unsubscribed\fP is not set.
.TP
\fBtime\fP		(boolean, default true)
When set, \fInn\fP will show the current time in the prompt line.
This is useful on systems without a
.I sysline (1)
utility.
.TP
\fBunshar-command\fP \fIshell-command\fP	(string, default "/bin/sh")
This is the command which is invoked by the \fBunshar\fP command.
.TP
\fBunshar-header-file\fP \fIfile\fP	(string, default "Unshar.Headers")
The name of the file in which the header and initial text of articles
unpacked with the \fB:unshar\fP command is saved.  Unless the file name
starts with a `/', the file will be created in the same directory as
the unpacked files.  The information is not saved if this variable is
not set.  Setting it to "Unshar.Result" will cause the headers and the
results from the unpacking process to be merged in a meaningful way
(unless \fBmmdf-format\fP is set).
.TP
\fBunsubscribe-mark-read\fP	(boolean, default true)
When set, unsubscribing to a group will automatically mark all current
articles read; this is recommended to keep the size of .newsrc down.
Otherwise, unread articles in the unsubscribe groups are kept in
.newsrc.  If \fBkeep-unsubscribed\fP is false, this variable has no
effect.
.TP
\fBupdate-frequency\fP		(integer, default 1)
Specifies how many changes need to be done to the .newsrc or select
files before they are written back to disk.  The default setting
causese .newsrc to be updated every time a group has been read.
.TP
\fBuse-selections\fP		(boolean, default true)
When set, \fInn\fP uses the selections and other article attributes
saved last time \fInn\fP was used.  If not set, \fInn\fP ignores the
select file.
.TP
\fBvisible-bell\fP	(boolean, default true)
When set, \fInn\fP will flash the screeen instead of "ringing the
bell" if the visible bell (flash) capability is defined in the
termcap/terminfo database.
.TP
\fBwindow\fP \fIsize\fP	(integer, default not set)
When set, \fInn\fP will reserve the last \fIsize\fP lines of the menu
screen for a preview window.  If not set, \fInn\fP will clear the
screen to preview an article if there are less than \fBmin-window\fP
lines at the
bottom of the screen.  As a side effect, it can also be used to reduce
the size of the menus, which may be useful on slow terminals.
.TP
\fBword-key\fP \fIkey\fP	(key, default ^W)
The key which erases the last input component or word
when \fInn\fP is prompting for a string, e.g. the last name in a path
name.
.TP
\fBwrap-header-margin\fP \fIsize\fP	(integer, default 6)
When set (non-negative), the customized header fields specified in
\fBheader-lines\fP will be split across several lines if they don't
fit on one line.  When \fIsize\fP is greater than zero, lines will be
split at the first space occurring in the last \fIsize\fP columns of
the line.  If not set (or negative), long header lines will be
truncated if they don't fit on a single line.
.\" ENDPART C
