/*
 *	Use this file as a template for new s- files
 */


/*
 *	Include header files containing the following definitions:
 *
 * 		off_t, time_t, struct stat
 */

#include <sys/types.h>
#include <sys/stat.h>


/*
 *	Define if your system has system V like ioctls
 */

#define	HAVE_TERMIO			/* */

/*
 *	Define to use terminfo database.
 *	Otherwise, termcap is used
 */

#define	USE_TERMINFO			/* */

/*
 *	Specify the library (or libraries) containing the termcap/terminfo
 *	routines.
 *
 *	Notice:  nn only uses the low-level terminal access routines
 *	(i.e. it does not use curses).
 */

#define TERMLIB	-ltermlib

/*
 *	Define HAVE_STRCHR if strchr() and strrchr() are available
 */

#define HAVE_STRCHR			/* */

/*
 *	Availability of varargs/vprintf/vsprintf is normally assumed
 *	on most systems, *unless* NO_VARARGS is defined either here or
 *	in the m- file.
 *
 *	To overrule a NO_VARARGS in the m- file, define HAVE_VARARGS
 *	below if the varargs feature is available, *including* the
 *	vprintf/vsprintf routines.
 *
 *	You may also define NO_VARARGS here, if varargs or the v*printf
 *	are not available on this OS, but the m- file doesn't say so.
 */

/* #define HAVE_VARARGS /* Ignore NO_VARARGS -- else default */
/* #define NO_VARARGS /* */

/*
 *	Define if a signal handler has type void (see signal.h)
 */

#define	SIGNAL_HANDLERS_ARE_VOID	/* */

/*
 *	Define if signals must be set again after they are caught
 */

#define	RESET_SIGNAL_WHEN_CAUGHT	/* */

/*
 *	Define MICRO_ALARM to timeout in 0.1 seconds if possible
 */

#define MICRO_ALARM()	alarm(1)	/* System V */
/*#define MICRO_ALARM()	ualarm(100000,0)	/* BSD 4.3 */

/*
 *	Define if your system has BSD like job control (SIGTSTP works)
 */

/* #define HAVE_JOBCONTROL			/* */


/*
 *	Define if your system has a 4.3BSD like syslog library.
 */

#undef HAVE_SYSLOG

/*
 *	Define if your system provides the "directory(3X)" access routines
 *
 *	If true, include the header file(s) required by the package below
 *	(remember that <sys/types.h> or equivalent is included above)
 *	Also typedef Direntry to the proper struct type.
 */

#define	HAVE_DIRECTORY			/* */

#include <dirent.h>			/* System V */
/* #include <sys/dir.h>				/* BSD */

typedef struct dirent Direntry;		/* System V */
/* typedef struct direct Direntry;		/* BSD */

/*
 *	Define if your system has a mkdir() library routine
 */

#define	HAVE_MKDIR			/* */


/*
 *	Pick one:
 *	Define HAVE_GETHOSTNAME if you have a BSD like gethostname routine.
 *	Define HAVE_UNAME if a system V compatible uname() is available.
 *	Define HOSTNAME_FILE "...." to a file containing the hostname.
 *	Define HOSTNAME_WHOAMI if sysname is defined in <whoami.h>.
 *
 *	As a final resort, define HOSTNAME to the name of your system
 *	(in config.h).
 */

/* #define HAVE_GETHOSTNAME			/* BSD systems */
/* #define HAVE_UNAME				/* System V */
/* #define HOSTNAME_FILE "/etc/uucpname"	/* or another file */
/* #define HOSTNAME_WHOAMI			/* in <whoami.h> */

/*
 *	Define HAVE_MULTIGROUP if system has simultaneous multiple group
 *	membership capability (BSD style).
 *	Also define NGROUPS or include the proper .h file if NGROUPS is
 *	not defined in <sys/param.h>.
 *	Also define GIDSET_TYPE to the type of the elements in the array
 *	initialized by getgroups() if different from "int" (many systems
 *	have a gid_t, but very few use it for getgroups()).
 */

/* #define HAVE_MULTIGROUP	/* BSD */

/*
 *	Define DETATCH_TERMINAL to be a command sequence which
 *	will detatch a process from the control terminal
 *	Also include system files needed to perform this HERE.
 *	If not possible, just define it (empty)
 */

/* #include "...." */

#define	DETATCH_TERMINAL /* setpgrp(); */


/*
 *	Specify where the Bourne Shell is.
 */

#define SHELL		"/bin/sh"

/*
 *	Define OLD_AWK to the name of the "old awk" program if your
 *	standard 'awk' is 'nawk' (new awk).  Use full path if necessary.
 *	(This is a temporary hack until I get time to fix the scripts
 *	which breaks nawk).
 */

/* #define OLD_AWK	"oawk"		/* */

/*
 *	Define AVOID_SHELL_EXEC if the system gets confused by
 *		#!/bin/sh
 *	lines in shell scripts, e.g. only reads #! and thinks it
 *	is a csh script.
 */

/* #define AVOID_SHELL_EXEC		/* */

/*
 *	Specify the default mailer to be invoked by nnmail
 */

#define	MAILX		"/usr/bin/mailx"	/* SV */
/* #define	MAILX	"/usr/ucb/Mail"		/* BSD */

/*
 *	Define the maximum length of any pathname that may occur
 */

#define	FILENAME 	256


/*
 *	Define standard compiler flags here:
 */

#define COMPILER_FLAGS

/*
 *	If your system requires other libraries when linking nn
 *	specify them here:
 */

#define EXTRA_LIB
