#!/usr/local/bin/perl
# -----------------------------------------------------------------
# bdtool.pl
# 
# Author: Mic Bowman and Satya Venneti
#
# Create the initial page for the validation database maintenance
# scripts.
# -----------------------------------------------------------------
$ENV{"HARVEST_HOME"} = "/usr/local/harvest" 
	if (!defined($ENV{"HARVEST_HOME"}));
$ENV{"HSR_HOME"} = "$ENV{'HARVEST_HOME'}/gatherers/HSR";
push(@INC,$ENV{"HSR_HOME"} . "/lib");
require 'cgi.pl';
require 'hsrlibrary.pl';
require 'bdlibrary.pl';

# -----------------------------------------------------------------
# BD_AddOpt
# -----------------------------------------------------------------
sub BD_AddOpt {
    local(*obj,*tags) = @_;
    local($sec,$min,$hour,$md,$mo,$yr,$wd,$yday,$is);

    # Update the object
    print STDERR "Tag: ", $in{"TAG"}, "\n";
    print STDERR "Value: ", $in{"VALUE"}, "\n";

    $obj{$in{"TAG"}} = $in{"VALUE"};

    # Add update attributes
    ($sec,$min,$hour,$md,$mo,$yr,$wd,$yday,$is) = localtime(time);
    $min = "0$min" if ($min < 10);
    $hour = "0$hour" if ($hour < 10);
    $obj{"Last-Update-Time"} = "$hour:$min " . @HSR_Month[$mo] . " $md, 19$yr";
    $obj{"Last-Update"} = "Add Optional Attribute";
}

# -----------------------------------------------------------------
# Main
# -----------------------------------------------------------------
sub Main
{
    local($stype,$shome,$sfile,$sop);
    local(%obj,%tags);

    # Initialize
    &HSR_Initialize;
    &CGIHeader;
    undef %obj;
    undef %tags;

    # Process the arguments
    &CGIParse;

    &CGIError("Server type unspecified") 
	if ((! defined $in{"TYPE"}) || ($in{"TYPE"} !~ /\S/));
    &CGIError("Server home unspecified") 
	if ((! defined $in{"HOME"}) || ($in{"HOME"} !~ /\S/));
    &CGIError("Server description unspecified") 
	if ((! defined $in{"FILE"}) || ($in{"FILE"} !~ /\S/));
    &CGIError("Missing parameter: TAG") 
	if ((! defined $in{"TAG"})  || ($in{"TAG"} !~ /\S/));
    &CGIError("Missing parameter: VALUE") 
	if ((! defined $in{"VALUE"})  || ($in{"VALUE"} !~ /\S/));

    $stype = $in{"TYPE"}; delete $in{"TYPE"};
    $shome = $in{"HOME"}; delete $in{"HOME"};
    $sfile = $in{"FILE"}; delete $in{"FILE"};

    # Make sure the file is in the descriptions home directory
    &CGIError("Invalid description file: $sfile")
	if (index($sfile,$Config{"Descriptions.Home"}) != 0);

    # Update the description file
    %tags = &BD_ReadTags("BROKER");

    &CGIError("Unable to update non-existant description file.")
	if (! -r $sfile);

    ($type,$url,%obj) = &HSR_ParseDescription($sfile);

    &BD_AddOpt(*obj,*tags);
    &HSR_WriteDescription($sfile,$stype,$obj{"Description-File"},%obj);
    &HSR_DisplayDescription($sfile);
}

# -----------------------------------------------------------------
&Main;
exit(0);
