#!/usr/local/bin/perl
# -----------------------------------------------------------------
# bdtool.pl
# 
# Author: Mic Bowman and Satya Venneti
#
# Create the initial page for the validation database maintenance
# scripts.
# -----------------------------------------------------------------
$ENV{"HARVEST_HOME"} = "/usr/local/harvest" 
	if (!defined($ENV{"HARVEST_HOME"}));
$ENV{"HSR_HOME"} = "$ENV{'HARVEST_HOME'}/gatherers/HSR";
push(@INC,$ENV{"HSR_HOME"} . "/lib");
require 'cgi.pl';
require 'hsrlibrary.pl';
require 'bdlibrary.pl';

# -----------------------------------------------------------------
# BD_Update
# -----------------------------------------------------------------
sub BD_Update {
    local(*obj,*tags) = @_;
    local($sec,$min,$hour,$md,$mo,$yr,$wd,$yday,$is);

    # Update the object
    foreach $key (keys %in) {
	if ($in{$key} =~ /^\s*$/) {
	    delete $obj{$key};
	} else {
	    $obj{$key} = $in{$key};
	}
    }

    # Ensure that the mandatory attributes are defined
    foreach $key (keys %tags) {
	($mandatory,$manual,$auto,$desc) = split('&',$tags{$key});
	next if ($manual ne "Y"); # Skip automatic tags
	if ($mandatory eq "Y") {
	    if ((! defined $obj{$key}) || ($obj{$key} =~ /^\s*$/)) {
		&CGIError("Mandatory attributes is not defined: $key");
	    }
	}
    }

    # Add update attributes
    ($sec,$min,$hour,$md,$mo,$yr,$wd,$yday,$is) = localtime(time);
    $min = "0$min" if ($min < 10);
    $hour = "0$hour" if ($hour < 10);
    $obj{"Last-Update-Time"} = "$hour:$min " . @HSR_Month[$mo] . " $md, 19$yr";
    $obj{"Last-Update"} = "Manual Update";
}

# -----------------------------------------------------------------
# Main
# -----------------------------------------------------------------
sub Main
{
    local($stype,$shome,$sfile,$sop);
    local(%obj,%tags,%dlist);

    # Initialize
    &HSR_Initialize;
    &CGIHeader;
    undef %obj;
    undef %tags;

    # Process the arguments
    &CGIParse;

    &CGIError("Server type unspecified") 
	if ((! defined $in{"TYPE"}) || ($in{"TYPE"} !~ /\S/));
    &CGIError("Server home unspecified") 
	if ((! defined $in{"HOME"}) || ($in{"HOME"} !~ /\S/));
    &CGIError("Server description unspecified") 
	if ((! defined $in{"FILE"}) || ($in{"FILE"} !~ /\S/));

    $stype = $in{"TYPE"}; delete $in{"TYPE"};
    $shome = $in{"HOME"}; delete $in{"HOME"};
    $sfile = $in{"FILE"}; delete $in{"FILE"};

    # Make sure the file is in the descriptions home directory
    &CGIError("Invalid description file: $sfile")
	if (index($sfile,$Config{"Descriptions.Home"}) != 0);

    # Update the description file
    %tags = &BD_ReadTags("BROKER");

    if (-r $sfile) {
	($type,$url,%obj) = &HSR_ParseDescription($sfile);
	&CGIError("Requested type is different than stored type: $type")
	    if ($type ne $stype);
    }

    &BD_Update(*obj,*tags);
    &HSR_WriteDescription($sfile,$stype,$obj{"Description-File"},%obj);

    %dlist = &BD_ReadDescriptions;
    if ((! defined $dlist{$sfile}) || ($dlist{$sfile} =~ /^\s*$/)) {
	&BD_AddDescription($stype,$sfile,$shome);
    }

    &HSR_DisplayDescription($sfile);
}

# -----------------------------------------------------------------
&Main;
exit(0);
