/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
*/

/* Copyright (c) CNIDR (see ../COPYRIGHT) */

/* $Log: xquestion.h,v $
 * Revision 1.1  1993/02/16  15:10:18  freewais
 * Initial revision
 *
 * Revision 1.4  92/03/17  14:19:56  jonathan
 * Separated from question.c.
 * 
 */

#ifndef _H_XQUESTION
#define _H_XQUESTION

#include "question.h"

typedef struct QuestionWindow {
  Widget shell;
  Widget keywordwid;
  ScrollList Sources;
  ScrollList RelevantDocuments;
  ScrollList ResultDocuments;
  Widget StatusWindow;
  Widget Textwindow;
  char *textbuffer;
} _QuestionWindow, *QuestionWindow;

typedef struct xquestion{
  Question q;
  char **Source_Items;
  char **Relevant_Items;
  char **Result_Items;
  QuestionWindow window;
} _XQuestion, *XQuestion;

/* function definitions */

XQuestion findQuestionWindow();
QuestionWindow MakeQuestionWindow();
void DeleteQuestionWindow();
char **buildQuestionItemList();
DocList build_response_list();
void SearchWais();
boolean init_for_source();
DocumentID getNextorPrevDoc();

#endif
