;;; tramp-uu.el --- uuencode in Lisp

;; Copyright (C) 2002  Free Software Foundation, Inc.

;; Author: Kai Grojohann <Kai.Grossjohann@CS.Uni-Dortmund.DE>
;; Keywords: comm, terminals

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; 

;;; Code:

(defvar tramp-uu-b64-alphabet
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
  "Mapping from base64-encoded character to the byte it represents.")

(defun tramp-uu-byte-to-uu-char (byte)
  "Return the character encoding BYTE."
  (+ byte 32))

(defun tramp-uu-b64-char-to-byte (char)
  "Return the byte that is encoded as CHAR."
  (or
   (string-match (regexp-quote (char-to-string char)) tramp-uu-b64-alphabet)
   (error "Unknown base64 character `%c'" char)))

(defun tramp-uuencode-region (beg end)
  "UU-encode the region between BEG and END."
  (let ((len (base64-encode-region beg end t))
	(padding 0)
	i c)
    (save-excursion
      (goto-char beg)
      (setq i 0)
      (while (< i len)
	(setq c (char-after (point)))
	(delete-char 1)
	(if (equal c ?=)
	    (progn
	      (incf padding)
	      (insert "`"))
	  (insert (tramp-uu-byte-to-uu-char (tramp-uu-b64-char-to-byte c))))
	(incf i)
	(when (zerop (% i 45))
	  (save-excursion
	    (beginning-of-line)
	    (insert (char-to-string (+ 32 45))))
	  (newline)))
      (unless (zerop (% i 45))
	(save-excursion
	  (beginning-of-line)
	  (insert (char-to-string (+ 32 (% i 45) (- padding))))
	  (newline)))
      (insert "`\nend\n")
      (goto-char beg)
      (insert "begin 600 xxx\n"))))

(provide 'tramp-uu)
;;; tramp-uu.el ends here
