/*
 * Copyright (C) 1994, 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * $Log: gtalkd.h,v $
 * Revision 1.6  1995/07/21  02:22:48  zappo
 * Changed version number
 *
 * Revision 1.5  1995/03/25  04:21:12  zappo
 * Updated copyright and non-ANSI prototypes
 *
 * Revision 1.4  1995/03/03  02:51:27  zappo
 * Modified some prototypes
 *
 * Revision 1.3  1995/02/12  14:13:39  zappo
 * Added sun forwarding flag to main context
 *
 * Revision 1.2  1995/02/11  17:17:42  zappo
 * formatting changes
 *
 * Revision 1.1  1995/02/01  03:47:09  zappo
 * Initial revision
 *
 */
#define DEBUG2

#ifndef GTALKD_
#define GTALKD_ "GTALK daemon version 0.2 (c) 1994 Free Software Foundation"

/* There may be duplicates, but load this just in case. */
#include "otalk.h"
#include "talk.h"
#include "gtalk.h"
#include "etl_union.h"

/*
 * lets define the context used thoughout
 * this talk program.
 */
struct DaemonContext {
  enum DaemonType     type;	/* current daemon type to emulate         */
  int                 sunf;	/* sun version forward flag               */
  struct HostObject  *me;	/* The current host.                      */
  struct InputDevice *talk;	/* udp port for talk (old) daemon service */
  struct InputDevice *udp_ring;	/* ringer socket for talking to ring srvc */
  long                checkrate; /* how often to clean out lists.         */
  pid_t               pid;	/* pid, (autoconf makes pid_t)            */
  unsigned char       tty;	/* flag set when not started from inetd   */
  unsigned char       forever;	/* run forever and ever flag              */
};

/*
 * Describe a request, meaning invites, phone addresses, and such
 */
struct RequestObject {
  CTL_MSG_GNU           request; /* request being stored             */
  char                 *extend;	/* extension character string        */
  struct InputDevice   *sender;	/* io virtualism of sender           */
  struct InputDevice   *retto;	/* return address listed in the mesg */
  struct timeval        stamp;	/* timestamp when this was received  */
  struct RequestObject *next;	/* closure                           */
  struct RequestObject *prev;
};

struct UserObject {
  char                 *name;	/* name of the user this describes     */
  uid_t                 uid;	/* The user id of this person          */
  char                 *tty;	/* requested tty to pester             */
  char                 *ringf;	/* The ringer file of this user        */
  struct InputDevice   *ringto;	/* address of any opened ringer socket */
  struct UserObject    *next;	/* closure                             */
  struct UserObject    *prev;
};

#ifdef PROTOTYPES
/* gtd_fusr.c */
extern struct UserObject *FUSR_alloc(char *name, char *tty);
extern char *FUSR_lookup(struct UserObject *uo);

/* gtd_reqst.c */
extern void GTR_read_request(struct DaemonContext *Ctxt, struct InputDevice *dev);

/* gtd_rman.c */
extern struct RequestObject *GCM_alloc(struct DaemonContext *Ctxt, struct InputDevice *dev, union ctl_msg *source, char *extend);
extern void GCM_free_request(struct RequestObject *request);
extern struct RequestObject *GCM_lookfor(struct RequestObject *ro);
extern struct RequestObject *GCM_looksame(struct RequestObject *ro);
extern struct RequestObject *GCM_lookid(struct RequestObject *ro);
extern struct RequestObject *GCM_findannounce(struct RequestObject *ro);
extern void GCM_timeout_messages(struct DaemonContext *Ctxt, struct InputDevice *dev);
extern void GCM_print();

/* gtd_annc.c */
extern int ANN_sendto(struct UserObject *uo, struct RequestObject *ro);

/* gtd_ring.c */
extern int RINGER_sendto(struct UserObject *uo, struct RequestObject *ro, struct DaemonContext *Ctxt);

#else /* PROTOTYPES */
/* gtd_fusr.c */
extern struct UserObject *FUSR_alloc();
extern char *FUSR_lookup();

/* gtd_reqst.c */
extern void GTR_read_request();

/* gtd_rman.c */
extern struct RequestObject *GCM_alloc();
extern void GCM_free_request();
extern struct RequestObject *GCM_lookfor();
extern struct RequestObject *GCM_looksame();
extern struct RequestObject *GCM_lookid();
extern struct RequestObject *GCM_findannounce();
extern void GCM_timeout_messages();
extern void GCM_print();

/* gtd_annc.c */
extern int ANN_sendto();

/* gtd_ring.c */
extern int RINGER_sendto();

#endif /* PROTOTYPES */


#endif /* GTALKD_ */
