########################## -*- Mode: Perl -*- ##########################
##
## File             : Form.pm
##
## Description      : Mapping of field names in forms to
##                    attributes in lattice
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Thu Feb 15 14:37:11 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Mon Nov 11 13:31:18 1996
##
## $State: Exp $
##
## $Id: Form.pm,v 5.1.1.1 1996/12/23 12:48:03 goevert Exp goevert $
##
## $Log: Form.pm,v $
## Revision 5.1.1.1  1996/12/23 12:48:03  goevert
## patch6: no Exporter required any longer
##
## Revision 5.1  1996/11/05 16:54:43  goevert
## *** empty log message ***
##
## Revision 5.0.1.4  1996/07/03 13:26:59  goevert
## patch19: case: no form file
##
## Revision 5.0.1.3  1996/05/31 15:43:46  goevert
## patch14: reading of form files changed (SFgate-server)
##
## Revision 5.0.1.2  1996/05/13 11:25:34  goevert
## patch1:
##
########################################################################


use strict;


package SFgate::Attributes::Form;


sub new
{
    my $class = shift;
    my $self  = {};
    bless $self, $class;

    $self->initialize(@_);

    return $self;
}


sub initialize
{
    my $self = shift;
    my($formfile) = @_;
    my($attributes, $diagnostic);
    
    if ($formfile && -r $formfile ) {
        ($attributes, $diagnostic) = &read_form_file($formfile);
    }
    else {
        $attributes = {};
        $diagnostic = '';
    }

    $self->{'attributes'} = $attributes;
    $self->{'diagnostic'} = $diagnostic;
}


sub read_form_file
{
    my($formfile) = @_;

    my $package = $formfile;
    $package =~ s/.*\///;
    $package =~ s/-//g;

    no strict 'refs';

    my $package_exists = $package . '::exists';

    eval qq[
            package $package;

            no strict 'vars';

            \$exists = 1;
            require '$formfile';
            
            1;
           ] unless $$package_exists;

    my $package_error = $package . '::error';
    if ($@) {
        $$package_error = $@;
    }
    if ($$package_error) {
        die "Error with $formfile: $$package_error\n";
        undef $@;
    }

    my $attributes = $package . '::attributes';

    return($$attributes, '');
}


sub get_lattice_attributes
{
    my $self = shift;

    my($attribute) = @_;
    ## local variables
    my($attributes) = $self->{'attributes'}->{$attribute};

    if (!defined($attributes)) {
        return($attribute);
    }
    return split(/,/, $attributes);
}


1;
