#ifndef CONF
  #define CONF

/* $Id: conf.h,v 1.6 1993/05/14 22:32:05 kdburg Exp $ */
/* $Log: conf.h,v $
 * Revision 1.6  1993/05/14  22:32:05  kdburg
 * change to HAVE_SPOOLDIR_TAYLOR
 *
 * Revision 1.5  1993/05/09  13:16:53  kdburg
 * make have-autopoll the default
 *
 * Revision 1.4  1993/05/08  23:17:34  kdburg
 * cleanup and to reflect changes made to autopoll/uupoll
 *
 * Revision 1.3  1993/04/29  10:46:34  kdburg
 * added def for STATUS_DIR
 *
 * Revision 1.2  1993/04/27  15:31:47  kdburg
 * rearranged the defs; changed LOG_DIR to ALOG_DIR in case uupoll
 * will have one too; we need then eventually 2 different dirs.
 *
 * Revision 1.1  1993/04/26  21:20:12  kdburg
 * Initial revision
 * */

/* --------- combined config file for uupoll and autopoll              */
/* --------- change the following defines to meet your needs           */

/*    define the default grade to be inserted into the pollfile name  */
#define DEF_GRADE "A"

/*    define the path to the directory which does contain uucico */
#define CICO_DIR "/usr/local/lib/uucp/uucico"

/*    define the path to the directory which holds all the uucp files.
 *    We'll place the poll file in one of it's subdirectories
 * */
#define SPOOL_DIR "/usr/spool/uucp"

/*    at least one of the follwing must be defined To use the second or  
 *    third set of definitions, change the  ``#if 1'' to ``#if 0'' 
 *    and change the appropriate ``#if 0'' to ``#if 1''.
 * */
#if 0
#define HAVE_SPOOLDIR_BSD
#endif
#if 0
#define HAVE_SPOOLDIR_HDB
#endif
#if 1
#define HAVE_SPOOLDIR_TAYLOR
#endif

/*    define the maximum number of sites in your config or L.sys */
#define SITE_MAX 100

/*    define the path to the directory which is to contain the
 *    message log created by uupoll and the file name itself.
 *    change the ``#if 1'' to ``#if 0'' to have the messages on stderr
 * */
#if 1
#define ULOG_FILE "/tmp/poll.log" 
#endif

/* change if to 0 if you don't have autopoll installed.               */
#if 1
#define AUTO_POLL
#endif

/*  The  following defs are irrelevant if you don't have autopoll     */

/*    define the options to be given to the at cmd (-s -c -m)
 *    the default is shown (use csh and send mail after execution)
 * */
#define AT_OPTION "-mc"

/*    Define the complete path to the autopoll program.
 *    The path must be the same as given in Makefile (lbindir) 
 * */
#define AUTO_DIR "/usr/local/lib/uucp/autopoll"

/*    define the path to the directory which is to contain the
 *    message log created by autopoll and the file name itself.
 *    change the ``#if 1'' to ``#if 0'' to have the messages on stderr
 * */
#if 1
#define ALOG_FILE "/tmp/poll.log" 
#endif

/*    define the full path to the directory which holds the status files
 *    The name should be given *except* the sitename. A trailing `/' if any
 *    must be given.
 *    Example: /usr/spool/uucp/.Status/sys.sitename
 *             then specify STATUS_DIR as
 *             "/usr/spool/uucp/.Status/sys."
 * */
#define STATUS_DIR "/usr/spool/uucp/.Status/" 
#endif
