#!/usr/local/bin/perl
# -----------------------------------------------------------------
# bdtool.pl
# 
# Author: Mic Bowman and Satya Venneti
#
# Create the initial page for the validation database maintenance
# scripts.
# -----------------------------------------------------------------
$ENV{"HARVEST_HOME"} = "/usr/local/harvest" 
	if (!defined($ENV{"HARVEST_HOME"}));
$ENV{"HSR_HOME"} = "$ENV{'HARVEST_HOME'}/gatherers/HSR";
push(@INC,$ENV{"HSR_HOME"} . "/lib");
require 'cgi.pl';
require 'hsrlibrary.pl';
require 'bdlibrary.pl';

# -----------------------------------------------------------------
# BD_BuildList
# -----------------------------------------------------------------
sub BD_BuildList {
    local($stype) = @_;
    local(%tlist);
    local($key,$desc,$file,$type);
    local($line,$output);

    %tlist = &BD_ReadTools;

    foreach $key (sort keys %tlist) {
	$desc = $tlist{$key};
	($file,$type) = split('&',$key,2);
	next if ($type ne $stype);

	$line = "<INPUT type=\"RADIO\" name=\"OP\" value=\"$file\"> $desc";
	$output = $output . $line . "<BR>\n";
    }

    return($output);
}

# -----------------------------------------------------------------
# Main
# -----------------------------------------------------------------
sub Main
{
    local($stype,$shome,$sfile);
    local($filename,$applyurl);

    &HSR_Initialize;

    &CGIHeader;
    &CGIParse;
    &CGIError("Server type unspecified") 
	if ((! defined $in{"TYPE"}) || ($in{"TYPE"} !~ /\S/));
    &CGIError("Server home unspecified") 
	if ((! defined $in{"HOME"}) || ($in{"HOME"} !~ /\S/));
    &CGIError("Server description unspecified") 
	if ((! defined $in{"FILE"}) || ($in{"FILE"} !~ /\S/));

    $stype = $in{"TYPE"};
    $shome = $in{"HOME"};
    $sfile = $in{"FILE"};
    $tools = &BD_BuildList($stype);

    $applyurl = &HSR_FileName("CGI","BDApply");
    $filename = &HSR_FileName("Library","BDTool.Skel");

    open(SKEL,"<$filename") ||
	&CGIError("Unable to generate update form, check configuration.");

    while (<SKEL>) {
	$_ =~ s/@FILE@/$sfile/g;
	$_ =~ s/@TYPE@/$stype/g;
	$_ =~ s/@HOME@/$shome/g;
	$_ =~ s/@TOOLS@/$tools/g;
	$_ =~ s/@APPLYURL@/$applyurl/g;
	print $_;
    }

    close(SKEL);

}

# -----------------------------------------------------------------
&Main;
exit(0);
