#include <stdio.h>
#include "defines.h"
#include "declares.h"
#include "install.h"
#include <gdbm.h>

/* ------------------------------------------------------------
			engine.c

   This program is a sample search engine shell for WHOIS++. It
   is intended to be launched by the query engine to perform 
   the actual searches. It reads stdin for the elements of the
   query structure, and returns the hits on stdout and exits.
   
   ------------------------------------------------------------ */

main (argc, argv) {

    struct term_type *tptr;

    int ch, count = 0, fetching;
    int i;
    char my_attr[100],my_value[100];



    /* set up query structure  */
    qptr = &query;
    qptr->termptr = NULL;


    /* first fetch version string */
    if ( gets(qptr->version) == NULL) {
        fprintf (stderr, "ERROR READING VERSION\n");
        exit (1);
    }


    /* now fetch global constraints string */
    if ( gets(qptr->constraints) == NULL) {
        fprintf (stderr, "ERROR READING GLOBAL CONSTRAINTS\n");
        exit (1);
    }


    /* now loop fetching search specifiers  */


    tptr = (struct term_type *) malloc (sizeof(struct term_type));

    while ((tptr->command = getchar()) != EOF) {
        if(tptr->command == '\n') {
            continue;
        }
        else {
        }

        /* now fetch elements of a term */

        /* fetch constraints string */
        if ( gets(tptr->constraints) == NULL) {
            printf ("ERROR READING CONSTRAINTS\n");
            exit (1);
        }

        /* fetch attribute string */
        if ( gets(tptr->attribute) == NULL) {
            printf ("ERROR READING ATTRIBUTE\n");
            exit (1);
        }


        /* fetch value string */
        if ( gets(tptr->value) == NULL) {
            printf ("ERROR READING ATTRIBUTE\n");
            exit (1);
        }


        /* now link in new term */
        tptr->nextptr = qptr->termptr;
        qptr->termptr = tptr;

        /* and make another one for the next go-round*/
        tptr = (struct term_type *) calloc (1,sizeof(struct term_type));
    }

    /* okay, we have all the terms, now process */


    tptr = qptr->termptr;
    while (tptr != NULL) {

        switch (tptr->command) {
        case HELP:
            do_help(tptr->value);

            break;

        case HANDLE:
            do_string_lookup("handle", tptr->value);
            break;

        case ATTRIBUTE:
            strcpy(my_attr,tptr->value);
            break;

        case VALUE:
            strcpy(my_value,tptr->value);
            break;

        case ATTRIBUTEVAL:
            do_string_lookup(tptr->attribute, tptr->value);
            break;

        case TEMPLATE:
            break;

        case SEARCH_ALL:
            printf(" Searched all fields for: %s\n", tptr->value);
            do_string_lookup("all", tptr->value);
            break;

        default:
            printf ("     +++ BOGUS COMMAND!: < %d >\n", tptr->command);
            exit (1);
        }
        tptr = tptr->nextptr;
    }

    exit(0);
}

do_help(ptr)
char *ptr; 
{

    FILE *fp, *fopen();
    char buffer[BUFSIZ];
    char *fgets();
    char *helpfile;

    printf ("     --- so, you want help?\n");

    helpfile = HELP_FILE;

    if (strlen(ptr)) {
        if (!strcmp(ptr, "help")) {
            helpfile = HELPHELP_FILE;
        }
        else {
            printf ("Sorry, help with arguments is not yet supported\n"); 
            printf ("Try 'help' for more details\n"); 
            return (1);
        }
    }
    if ((fp = fopen(helpfile, "r")) == NULL) {
        printf ("     --- Sorry, can't access help. Please try again later\n");
        return;
    }


    while ((fgets(buffer, BUFSIZ, fp)) != NULL) {
        printf ("%s", buffer);
    }


}

#include <sys/types.h>
#include <time.h>
do_string_lookup(attr,val)
char *attr,*val;
{

    char new_line_buf[1000];
    char word[100];
    char *p;
    int attr_type=0;

    char command[1000];
    if(!strncasecmp(attr,"name",4))
        attr_type=1;
    else if(!strncasecmp(attr,"title",5))
        attr_type=3;
    else if(!strncasecmp(attr,"department",10))
        attr_type=2;
    else if(!strncasecmp(attr,"work-tel",8))
        attr_type=4;
    else if(!strncasecmp(attr,"work-address",12))
        attr_type=6;
    else if(!strncasecmp(attr,"email",5))
        attr_type=5;
    else if(!strncasecmp(attr,"handle",6))
        attr_type=10;
    if(attr_type==0){
        for(attr_type=1; attr_type<11; attr_type++){
            p=strtok(val," ,");
            do{
                sprintf(word,"%d%s",attr_type,p);
                strcat(new_line_buf,word);
                strcat(new_line_buf," ");
            }
            while((p=strtok(NULL," ,"))!=NULL);
            sprintf(command,"/home/fullton/whois++/alpha-release/wais-8-b5/bin/waissearch -d /home/fullton/whois++/alpha-release/whoisdb %s",new_line_buf);
            system(command);
        }
    }
    else{
        p=strtok(val," ,");
        do{
            sprintf(word,"%d%s",attr_type,p);
            strcat(new_line_buf,word);
            strcat(new_line_buf," ");
        }
        while((p=strtok(NULL," ,"))!=NULL);
        sprintf(command,"/home/fullton/whois++/alpha-release/wais-8-b5/bin/waissearch -d /home/fullton/whois++/alpha-release/whoisdb %s",new_line_buf);
        system(command);
    }
}
do_lookup(attr, val)
char *attr,*val;
{



    FILE *fp,*flist;
    char buf[100];
    GDBM_FILE dbf,lbf,rev;
    char name[500],*p;
    char host[500],lname[500];
    char nbuf[500];
    int count=0;
    int loop=0;
    char word[50];
    datum key,content,nkey,ncontent;
    int i;
    int *lst;
    struct t {
        int host_count;
        time_t tm;
    }
    *ts;

    chdir(WHOIS_DIRECTORY);
    dbf=gdbm_open("local-info.db",512,GDBM_READER,0777,NULL);
    rev=gdbm_open("template-reverse.db",512,GDBM_READER,0777,NULL);
    sprintf(nbuf,"%s=%s",attr,val);
    strupr(nbuf);
    if(!strncasecmp(attr,"poll",4)){
        for(key=gdbm_firstkey(dbf);key.dptr!=NULL; key=gdbm_nextkey(dbf,key)){
            printf("%s\n",key.dptr);
            free(key.dptr);
        }
        return;
    }
    p=index(nbuf,'=');
    if(!p){
        printf("Syntax Error\n");
        return; 
    }
    *p='+';
    key.dsize=strlen(nbuf)+1;
    key.dptr=nbuf;

    content=gdbm_fetch(dbf,key);
    if(content.dptr==NULL){
        return;
    }
    else{
        ts=(struct t *)content.dptr;
    }
    lbf=gdbm_open("match-list.db",512,GDBM_READER,0777,NULL);
    ncontent=gdbm_fetch(lbf,key);
    gdbm_close(lbf);
    lst=(int *)ncontent.dptr;
    for(i=0; i<ts->host_count; i++){
        loop=lst[i];
        key.dptr=&loop;
        key.dsize=sizeof(int);
        content=gdbm_fetch(rev,key);
        printf("Handle: %s\n",content.dptr);
        fp=fopen(content.dptr,"r");
        if(fp){
            while(fgets(buf,100,fp)!=NULL)
                printf("%s",buf);
            fclose(fp);
        }
        free(content.dptr);
        printf("\n");
    }
    free(ts);
}



