/* ------------------------------------------------------------
		declares.h

   Contains the global declares for the query engine.

   See the end for details of the structure of a query.

   ------------------------------------------------------------ */

/* Following used by input routine and get_token() */

char line[BUFSIZ];
char *ptr;


/* following used by parsing routines */

/* for get_token() and parse_term() */

int token, token_value;	
char *startptr, token_string [BUFSIZ];




/* ---------------------------------------  *\
	QUERY AND TERM STRUCTURES
\* ----------------------------------------  */

/* ----------------------------------------

   a query consists of one query structure, 
   with a termptr pointing to one or more
   terms.

   The "constraints" string in the query is for 
   global constriants, whle each term contains
   the constraints associated with that term.
   ----------------------------------------  */

struct query_type {
	struct term_type *termptr;
	int command_type;
	char constraints[BUFSIZ];
	char version[BUFSIZ];
	};

/* each term is some set of the following.  */

struct term_type {
	int command;
	int command_type;
	char constraints[BUFSIZ];
	char attribute[BUFSIZ];
	char value[BUFSIZ];
	struct term_type *nextptr;
	};
/* used by parse_query() and in main() */

struct query_type *qptr, query;
/* used by parse_term() and parse_query() */

struct term_type *termptr;


