########################## -*- Mode: Perl -*- ##########################
##
## File             : Label.pm
##
## Description      : converts tagged format (bibdb-html)
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : 
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Jul 18 11:07:24 1996
##
## $State: Exp $
##
## $Id: Label.pm,v 5.1 1996/11/05 16:55:05 goevert Exp goevert $
##
## $Log: Label.pm,v $
## Revision 5.1  1996/11/05 16:55:05  goevert
## *** empty log message ***
##
## Revision 5.0.1.4  1996/11/04 13:08:53  goevert
## patch21: cons instead of MakeMaker
##
## Revision 5.0.1.3  1996/05/23 17:07:17  goevert
## patch13: removed no strict 'vars';
##
## Revision 5.0.1.2  1996/05/21 15:52:07  goevert
## patch12: fixed return value
##
## Revision 5.0.1.1  1996/05/13 11:27:15  goevert
## patch1:
##
########################################################################


package SFgate::Converter::Label;


use strict;


## #####################################################################
## convert
## #####################################################################
## interface for SFgate to convert one document
##
## (string) $text:     document to convert
## (string) $headline: headline of document to convert
##
## By default every document is printed with its corresponding wais
## headline. If you want to derive another headline just change
## the $headline variable according to your needs.
##
## HTML special characters (&, <, >) should be encoded in text not
## being HTML code. To do this you can use the function
## &::encode_entities, e.g. $ntext = &::encode_entities($ntext)
## encodes the special chars in $ntext.
##
## returns:
## - string: the converted document ($ntext)
## - string: headline of converted document ($headline)
##
sub convert
{
    my($text, $headline) = @_;
    ## local variables
    local($_);
    my($headtag, $headpos, $head, $label, $value);
    ## return value
    my($ntext);
    
    if ($text =~ /(<h[0-9]>)/i) {
        $headtag = $1;
        $headpos = index($text, $headtag);
        $head    = substr($text, $headpos + 4, 300);
        $headtag =~ s:<:</:;
        $head    =~ s:($headtag)(.|\n)*::i;
        $text    =  substr($text, 0, $headpos) .
        substr($text, $headpos + 4 + length($head) + length($1));
    }
    $headline = $head  if $head;

    # emphasize labels
    for (split('\n', $text)) {
        next if /^$/;
        ($label, $value) = m/^\s*([A-Z][A-Z]):(.*)/;
        if ($value && $label =~ /^\s*\w+/) {
            $ntext .= "<b>$label</b>:$value\n";
        }
        else {
            $ntext .= "$_\n";
        }
    }

    return($ntext, $headline);
}


1;
